# $Date: 1995/07/14 10:18:06 $ $Author: kg $ $Revision: 1.9.2.1 $ #

# kg, 13/01/94 #

#++
sinh -- the hyperbolic sine

sinh(x)

x - expression
++#

sinh:= proc(x)
    local f;
    name sinh;
begin
    if x::sinh <> FAIL then return(x::sinh(args())) end_if;
    if args(0) <> 1 then error("wrong no of args") end_if;

    case type(x)
    of DOM_INT do
    of DOM_RAT do
	if x < 0 then return(-sinh(-x)) end_if;
	break;
    
    of DOM_FLOAT do
	return(funcattr(sinh,"float")(x));

    of DOM_COMPLEX do
	if domtype(op(x,1)) = DOM_FLOAT or
	   domtype(op(x,2)) = DOM_FLOAT then
	    return(funcattr(sinh,"float")(x))
	end_if;
	break;

    of "_mult" do
	f:= op(x, nops(x));
	if testtype(f, Type::RealNum) then
	    if f < 0 then return(-sinh(-x)) end_if;
	end_if;
	break;

    end_case;

    procname(x)
end_proc:

sinh:= funcattr(sinh, "print", "sinh"):

sinh:= funcattr(sinh, "diff", proc(e)
    local i;
begin
    e:= op(e,1); diff(e, args(i) $ i=2..args(0)) * cosh(e)
end_proc):

# sinh(-x)     = -sin(x)                                                  #
# sinh(x +- y) = sinh(x) * cosh(y) +- sinh(y) * cosh(x)                   #
#                n                                                        #
#               ---                                                       #
#               \   (   n  )                                              #
# sinh(n * x) = /   ( 2*i+1) cosh(x)^(n-2*i-1)*sinh(x)^(2*i+1)*(-1)^(i+1) #
#               ---                                                       #
#               i=0                                                       #



sinh := funcattr(sinh, "expand", proc(x)
  local n, t, y;
begin
  y := expand(x);

  case type(y)

    of "_plus" do

       n := op(y, 1); y := subsop(y, 1=null());
       return(expand(sinh(n)*cosh(y)+cosh(n)*sinh(y)));

    of "_mult" do

       n := op(y, nops(y)); t := type(n);
       if t = DOM_INT or t = DOM_RAT then
          if n < 0 then
             return(expand(-sinh(-y)));
          elif t = DOM_INT and n > 0 then
             y := y / n;
             return(expand(2*sinh((n-1)*y)*cosh(y)-sinh((n-2)*y)));
          end_if
       end_if
 
  end_case;
 
  sinh(y)
 
end_proc):

sinh:= funcattr( sinh, "conjugate", fun((
    conjugate(args(1));
    if type(%) = "conjugate" then hold(sinh)(%)
    else sinh(%)
    end_if
)) ):

sinh:= funcattr(sinh,"info","asinh -- the inverse hyperbolic sine"):

sinh(0):= 0:

# end of file #
