# ok, 25/01/94 #

#++
The incomplete Gamma function

igamma(a, x)

a, x - expressions
++#

igamma := proc(a, x)

begin
	if args(0) < 2 then
	   error("2 arguments expected");
	end_if;
	if a::igamma <> FAIL then return(a::igamma(args())) end_if;
	if x::igamma <> FAIL then return(x::igamma(args())) end_if;
	if args(0) > 2 then
	    error("2 arguments expected")
	end_if;

	if domtype(a) = DOM_FLOAT or domtype(x) = DOM_FLOAT then
	   funcattr(igamma, "float")(a, x);
        elif a = 0 and x = 0 then 
           error("singularity encountered.")
	elif x = 0 then
	     gamma(a);
	elif domtype(a) = DOM_INT then
	     if a = 0 then
		x^a*eint(x)
	     elif 0 < a and a < 1000 then # See apendix (1) #
	        fact(a-1) * exp(-x) * _plus(x^k/fact(k) $ k = 0..a-1);
	     else
		procname(a, x);
	     end_if
	elif domtype(2*a) = DOM_INT then
	     if ceil(abs(a)) < 100 then # See apendix (2) #
		 if a = 1/2 then 
		    PI^(1/2) * erfc(sqrt(x));
		 elif 1/2 < a then
		    x^(a-1)*exp(-x)+(a-1)*igamma(a-1,x);
		 else
		    (igamma(a+1,x)-x^a*exp(-x))/a;
		 end_if
	     else
		 procname(a, x);
	     end_if
	else
	     procname(a, x);
	end_if
end_proc:

igamma:= funcattr(igamma, "print", "igamma"):
igamma:= funcattr(igamma, "type", "igamma"):
igamma:= funcattr(igamma, "conjugate", fun((
    conjugate(args(1));
    if type(%) = "conjugate" then hold(igamma)(%)
    else igamma(%)
    end_if
)) ):
igamma:= funcattr(igamma, "info", "igamma -- the incomplete Gamma function [try ?igamma for details]"):

# (1) Due to the complexity compute this sum only if a < 1000 #
# (2) To compute igamma(x, n/2) call igamma recursively.      #
#     Recursion depth is ceil(abs(n/2)), so restrict this     #
#     computation to a maximum depth of 100                   #

# end of file #
