
# ok, 20/04/94 #

#++
The Gamma function

gamma(x)

x - an expression
++#

gamma := proc(x)
begin
	if x::gamma <> FAIL then return(x::gamma(args())) end_if;

	if args(0) <> 1 then
           error("1 argument expected");
	end_if;

	case domtype(x)

	  of DOM_FLOAT do

	     return( funcattr(gamma, "float")(x) );

	  of DOM_INT do

             if x <= 0 then
                error("singularity encountered.");
	     elif x < 1000 then
	        # gamma(x) = (x-1)! ,                 #
                # but compute (x-1)! only if x < 1000 #
		return( fact(x-1) )
             end_if;
	     break;

	   of DOM_COMPLEX do
 
              if domtype(op(x, 1)) = DOM_FLOAT or 
                 domtype(op(x, 2)) = DOM_FLOAT then
                 return( funcattr(gamma, "float")(x) );
              end_if;
              break;
	   
	   of DOM_RAT do

	      if 1 < x and x <= 500 then
		 # compute (x-1)*gamma(x-1) only if x <= 500 #
                 return( (x-1) * gamma(x-1) )
	      elif x < 1/2 and 
                   (domtype(4*x) = DOM_INT or domtype(6*x) = DOM_INT) then
		 return( level( PI * csc(PI*x) / gamma(1-x) ) )
              end_if;
	      break;
                 
	end_case;

	procname(x)
end_proc:

gamma:= funcattr(gamma, "print", "gamma"):

gamma:= funcattr(gamma, "diff", proc(e)
    local i;
begin
    e:= op(e,1); diff(e, args(i) $ i=2..args(0)) * psi(e) * gamma(e)
end_proc):

gamma:= funcattr( gamma, "conjugate", fun((
    conjugate(args(1));
    if type(%) = "conjugate" then hold(gamma)(%)
    else gamma(%)
    end_if
)) ):

gamma:= funcattr( gamma, "info", "gamma -- the Gamma function [try ?gamma for details]"):

gamma:= funcattr( gamma, "series",
proc(f,x,n) local l,i,p,a;
begin
   l:=limit(f,x);
   if l=0 or testtype(l,Type::NegInt) then # simple pole #
      # use gamma(x+1)=x*gamma(x), formula 6.1.15 #
      p:=_mult(f+i $ i=0..-l);
      series(gamma(f-l+1)/p,x,n)
   elif l=infinity then # Stirling formula, see 6.1.40 #
      a:=(f/E)^f*sqrt(2*PI*f);
      l:=bernoulli(2*i)/2/i/(2*i-1)/f^(2*i-1)$i=1..n-4;
      a*Series::series(exp(_plus(l)),x,n);
   else Series::unknown(gamma(f),x,n)
   end_if
end_proc):

gamma(1/2) := PI^(1/2):

