# $Date: 1995/07/14 10:17:59 $ $Author: kg $ $Revision: 1.13.2.1 $ #

# kg, 13/01/94 #

#++
exp -- the exponential function

exp(x)

x - expression
++#

exp:= proc(x)
    name exp;
    local t, y;
option remember;
begin
    if x::exp <> FAIL then return(x::exp(args())) end_if;
    if args(0) <> 1 then error("wrong no of args") end_if;

    case type(x)
    of DOM_FLOAT do
	return(funcattr(exp,"float")(x));

    of DOM_COMPLEX do
	if domtype(op(x,1)) = DOM_FLOAT or
	   domtype(op(x,2)) = DOM_FLOAT then
	    return(funcattr(exp,"float")(x))
        end_if;
	break;

    of "_mult" do
        # exp(y*PI/2/I) = I^(-y) #
        y:=x*I*2/PI;
        if testtype(y, DOM_INT) then
           # exp( I*PI*n/2) = I^n , n an integer #
           return(I^(-y));
        end_if;
        # exp(ln(x)*Constant) = x^Constant #
        if nops(x)=2 then
           if type(op(x,1))="ln" and testtype(op(x,2),Type::Constant) then
              return(op(op(x,1))^op(x,2))
           end_if
        end_if;
        break;

    of "ln" do return(op(x,1));
    end_case;

    procname(x)
end_proc:

exp:= funcattr(exp, "print", "exp"):
exp := funcattr( exp, "abs", fun( exp(Re(args(1))) ) ):

# exp(-x)        = 1/exp(x)                 #
# exp( x + y)    = exp(x) * exp(y)          #
# exp(n * x)     = exp(x) ^ n               #
# exp(x * ln(y)) = x ^ y                    #

exp := funcattr(exp, "expand", proc(x)
  local n, t, y, k;
begin
  y := expand(x);

  case type(y)

    of "_plus" do

       return(expand(_mult(map(op(y), exp))));

    of "_mult" do

       n := op(y, nops(y)); t := type(n);
       if t = DOM_INT or t = DOM_RAT then
          return(expand(exp(y/n)) ^ n);
       else
          for k from 1 to nops(y) do
              n := op(y, k);
              if testtype(n, "ln") then
                 return(op(n, 1) ^ subsop(y, k=1))
              end_if
          end_for
       end_if
 
  end_case;
 
  exp(y)
 
end_proc):

exp := funcattr( exp, "sign", proc(x) 
	local a;
    begin
	a := op(x,1);
	if testtype(a,Type::RealNum) 
	or testtype(sign(a),Type::RealNum) then 
	    return( 1 )
	end_if;
	if domtype(a) = DOM_COMPLEX then
	    if domtype(op(a,1)) = DOM_FLOAT 
	    or domtype(op(a,2)) = DOM_FLOAT then 
		return( exp(I*Im(a)) )
	    end_if
	end_if;
	a := Im(a);
	if not has(a,{Im,Re}) then exp(I*a) else hold(sign)(x) end_if
    end_proc):

exp:= funcattr( exp, "conjugate", fun((
    conjugate(args(1));
    if type(%) = "conjugate" then hold(exp)(%)
    else exp(%)
    end_if
)) ):

exp:= funcattr( exp,"info","exp -- the exponential function" ):

exp(0):= 1:
exp(1):= E:
exp(-1):= 1/E:

# end of file #
