# $Date: 1995/07/14 10:17:58 $ $Author: kg $ $Revision: 1.10.2.1 $ #

# kg, 13/01/94 #

#++
cosh -- the hyperbolic cosine

cosh(x)

x - expression
++#

cosh:= proc(x)
    local f;
    name cosh;
begin
    if x::cosh <> FAIL then return(x::cosh(args())) end_if;
    if args(0) <> 1 then error("wrong no of args") end_if;

    case type(x)
    of DOM_INT do
    of DOM_RAT do
	if x < 0 then return(cosh(-x)) end_if;
	break;
    
    of DOM_FLOAT do
	return(funcattr(cosh,"float")(x));

    of DOM_COMPLEX do
	if domtype(op(x,1)) = DOM_FLOAT or
	   domtype(op(x,2)) = DOM_FLOAT then
	    return(funcattr(cosh,"float")(x))
	end_if;
	break;

    of "_mult" do
	f:= op(x, nops(x));
	if testtype(f, Type::RealNum) then
	    if f < 0 then return(cosh(-x)) end_if;
	end_if;
	break;

    end_case;

    procname(x)
end_proc:

cosh:= funcattr(cosh, "print", "cosh"):

cosh:= funcattr(cosh, "diff", proc(e)
    local i;
begin
    e:= op(e,1); diff(e, args(i) $ i=2..args(0)) * sinh(e)
end_proc):

# cosh(-x)     = cosh(x)                                        #
# cosh(x +- y) = cosh(x) * cosh(y) +- sinh(x) * sinh(y)         #
#                n                                              #
#               ---                                             #
#               \   (  n )                                      #
# cosh(n * x) = /   ( 2*i) cosh(x)^(n-2*i)*sinh(x)^(2*i)*(-1)^i #
#               ---                                             #
#               i=0                                             #



cosh := funcattr(cosh, "expand", proc(x)
  local n, t, y;
begin
  y := expand(x);

  case type(y)

    of "_plus" do

       n := op(y, 1); y := subsop(y, 1=null());
       return(expand(cosh(n)*cosh(y)+sinh(n)*sinh(y)));

    of "_mult" do

       n := op(y, nops(y)); t := type(n);
       if t = DOM_INT or t = DOM_RAT then
          if n < 0 then
             return(expand(cosh(-y)));
          elif t = DOM_INT and n > 0 then
             y := y / n;
             return(expand(2*cosh((n-1)*y)*cosh(y)-cosh((n-2)*y)));
          end_if
       end_if
 
  end_case;
 
  cosh(y)
 
end_proc):

cosh:= funcattr( cosh, "conjugate", fun((
    conjugate(args(1));
    if type(%) = "conjugate" then hold(cosh)(%)
    else cosh(%)
    end_if
)) ):

cosh(0):= 1:

cosh:= funcattr( cosh, "info", "acosh -- the hyperbolic cosine"):

# end of file #
