besselY:=proc(n,z)
begin
   if z::besselY <> FAIL then return( z::besselY(args()) ) end_if;

   if type(z)=DOM_FLOAT then return(funcattr(besselY,"float")(n,z))
   elif type(z)=DOM_COMPLEX then
      if type(op(z,1))=DOM_FLOAT or type(op(z,2))=DOM_FLOAT then
         return(funcattr(besselY,"float")(n,z))
      end_if
   end_if;
   hold(besselY)(n,z)
end_proc:

# use formula 9.1.11 of Abramowitz & Stegun :
   Y_n(z) = -(z/2)^(-n)/PI*sum((n-k-1)!/k!*(z^2/4)^k,k=0..n-1)
              +2/PI*ln(z/2)*J_n(z)
              - (z/2)^n/PI*sum((psi(k+1)+psi(n+k+1))*(-z^2/4)^k/k!/(n+k)!,k=0..infinity)
  the last term should be divided by n! ???
  recurrence Y_{n+1}(x)=2*n/x*Y_n(x)-Y_{n-1}(x)
#
besselY:=funcattr(besselY,"float",
proc(n,z) local s1,s2,s3,t,m,mm,k,eps,u,olds,DIGITS;
begin
   DIGITS:=DIGITS+max(0,round(abs(z)/ln(10)));
   if type(n)<>DOM_INT then return(hold(besselY)(n,float(z))) end_if;
   m:=float(z/2); 
   eps:=10^(-DIGITS); mm:=m*m;
   if n=0 then s1:=0 else
      t:=fact(n-1); s1:=t;
      for k from 1 to n-1 do
         t:=t*mm/(n-k)/k; s1:=s1+t;
      end_for;
      s1:=-s1/m^n;
   end_if;
   s2:=2*ln(m)*float(besselJ(n,z));
   t:=1.0/fact(n); u:=psi(1.0)+psi(n+1.0); s3:=t*u; k:=1;
   repeat
      t:=-t*mm/k/(n+k);
      u:=u+1/k+1/(n+k);
      olds:=s3;
      s3:=s3+t*u;
      k:=k+1;
   until s3=olds end_repeat;
   s3:=s3*m^n;
   (s1+s2-s3)/float(PI)
end_proc):

besselY:=funcattr(besselY,"info",
"besselY(v,z) -- Bessel function of 2nd kind, order v and argument z"):

# end of file #

