besselJ:=proc(v,z)
begin
   if z::besselJ <> FAIL then return( z::besselJ(args()) ) end_if;

   if type(z)=DOM_FLOAT then return(funcattr(besselJ,"float")(v,z))
   elif type(z)=DOM_COMPLEX then
      if type(op(z,1))=DOM_FLOAT or type(op(z,2))=DOM_FLOAT then
         return(funcattr(besselJ,"float")(v,z))
      end_if
   end_if;
   procname(v,z)
end_proc:

# formula 9.1.10 of Abramowitz & Stegun:
   J_v(z)=(z/2)^v*sum((-z^2/4)^k/k!/Gamma(v+k+1),k=0..infinity)
   recurrence J_{n+1}(x)=2*n/x*J_n(x)-J_{n-1}(x)
   ok with Table 9.1 p. 390, 392, 394
#
besselJ := funcattr(besselJ,"float",
proc(v,z)
local s,t,k,m,DIGITS,olds;
begin
   DIGITS:=DIGITS+max(0,round(abs(z)/ln(10)));
   t:=1; s:=t; m:=float(-z^2/4);
   # the maximal value of t is obtained for z^2/4 = k*(v+k)
       i.e. for k ~ z/2, and then we have ln(t) ~ z
       thus we need z/ln(10) more digits
   #
   k:=1; repeat
      t:=t*m/k/(v+k);
      olds:=s;
      s:=s+t;
      k:=k+1;
   until s=olds end_repeat;
   float(z/2)^v*s/gamma(float(v+1));
end_proc):

besselJ := funcattr(besselJ,"info",
"besselJ(v,z) -- Bessel function of first kind, order v and argument z"):

# end of file #

