#++

sharelib::subdirs returns a sequence of strings, representing all
subdirectories of the directory 'dir'. 
It is based on the Unix command ls -R | fgrep ":"
sharelib::subdirs returns FAIL, if 
1) operating system is not based on Unix
2) the invokation of the command in the host OS fails
3) writing/reading the file _subdirs_ fails

++#

sharelib::subdirs := proc(dir)
  local fd, filename, path_list, subdir;
begin
  if sysname() <> "UNIX" then
     return(FAIL) # Not an Unix based OS #
  end_if;
  filename:="_subdirs_";
  if system("ls -R ".dir." | fgrep \":\" > ".filename) <> 0 then
     return(FAIL) # Can't invoke a command in the host OS #
  end_if;
  fd:=fopen(filename);
  if fd = FAIL then
     return(FAIL) # Can't open file subdirs #
  end_if;
  path_list:=null();
  while type((subdir:=ftextinput(fd))) <> DOM_NULL do
        path_list:=path_list,substring(subdir, 0, strlen(subdir)-1);
  end_while;
  fclose(fd); 
  system("rm -f ".filename);
  path_list
end_proc:
