
# kg, 08/07/94 #

#
Turtle -- 2d turtle graphic primitives
#

#
Operands of a turtle:
1 - x-position
2 - y-position
3 - direction radian (0..2*PI)
4 - list of polygons of two points
5 - actual color, a list [r,g,b]
6 - state stack
#

Turtle:= domain():
Turtle::name:= "Turtle":

# a new turtle starts at (0,0) heading north, green color, empty stack #
Turtle::new:= proc() begin
    if args(0) <> 0 then error("no args allowed") end_if;
    new(Turtle, 0.0, 0.0, 0.5*float(PI), [], [0.0,1.0,0.0], [])
end_proc:

# print -- print turtle #
Turtle::print:= proc(t) begin
    if testargs() then
	if not testtype(args(), Turtle) then
	    error("no turtle")
	end_if
    end_if;
    "(".expr2text(extop(t,1)).",".expr2text(extop(t,2)).") -> ".
    expr2text(extop(t,3)*180.0/float(PI))
end_proc:

# testtype -- test if expression is turtle #
Turtle::testtype:= proc(e,T) begin
    if T = Turtle then
	if domtype(e) = Turtle then
	    return(TRUE)
	end_if
    end_if;
    FAIL
end_proc:

# color -- set actual turtle color #
Turtle::color:= proc(t,r,g,b) begin
    if testargs() then
	if not testtype(args(), Type::Product(Turtle,
		Type::RealNum, Type::RealNum, Type::RealNum)) then
	    error("illegal args")
	end_if;
	if max(r,g,b) > 1.0 then
	    error("wrong color value")
	end_if;
	if max(r,g,b) < 0.0 then
	    error("wrong color value")
	end_if;
    end_if;
    extsubsop(t, 5=[r,g,b])
end_proc:

# left -- turn left about d without changing position #
Turtle::left:= proc(t,d) begin
    if testargs() then
	if not testtype(args(), Type::Product(Turtle,Type::RealNum)) then
	    error("illegal args")
	end_if
    end_if;
    extsubsop(t, 3=(extop(t,3) + float(d*PI/180.0)))
end_proc:

# right -- turn right about d without changing position #
Turtle::right:= proc(t,d) begin
    if testargs() then
	if not testtype(args(), Type::Product(Turtle,Type::RealNum)) then
	    error("illegal args")
	end_if
    end_if;
    extsubsop(t, 3=(extop(t,3) - float(d*PI/180.0)))
end_proc:

# move -- move about length l without drawing #
Turtle::move:= proc(t,l) begin
    if testargs() then
	if not testtype(args(), Type::Product(Turtle,Type::RealNum)) then
	    error("illegal args")
	end_if
    end_if;
    extsubsop(t, 1 = extop(t,2) + float(l)*cos(extop(t,3)),
		 2 = extop(t,1) + float(l)*sin(extop(t,3)))
end_proc:

# line -- draw line with length l and actual color #
Turtle::line:= proc(t,l) local x, y, x0, y0; begin
    if testargs() then
	if not testtype(args(), Type::Product(Turtle,Type::RealNum)) then
	    error("illegal args")
	end_if
    end_if;
    x0:= extop(t,1);
    y0:= extop(t,2);
    x:= x0 + float(l)*cos(extop(t,3));
    y:= y0 + float(l)*sin(extop(t,3));
    extsubsop(t, 1 = x, 2 = y, 
    	4 = append(extop(t,4), polygon(point(x0,y0), point(x,y), Color=extop(t,5))))
end_proc:

# push -- push actual state onto stack #
Turtle::push:= proc(t) begin
    extsubsop(t, 6 = [[extop(t,1), extop(t,2), extop(t,3), extop(t,5)], extop(t,6)])
end_proc:

# pop -- pop new turtle state from stack #
Turtle::pop:= proc(t) local stack, state; begin
    stack:= extop(t,6);
    if nops(stack) = 0 then return(t) end_if;
    state:= stack[1];
    new(Turtle, state[1], state[2], state[3], extop(t,4), state[4], stack[2])
end_proc:

# pos -- return actual position #
Turtle::pos:= proc(t) begin
    if testargs() then
	if not testtype(args(), Turtle) then
	    error("no turtle")
	end_if
    end_if;
    (extop(t,1), extop(t,2))
end_proc:

# dir -- return actual direction #
Turtle::dir:= proc(t) begin
    if testargs() then
	if not testtype(args(), Turtle) then
	    error("no turtle")
	end_if
    end_if;
    extop(t,3)*180.0/float(PI)
end_proc:

# path -- return turtle path in a form suitable for a plot2d-command #
Turtle::path:= proc(t) begin
    if testargs() then
	if not testtype(args(), Turtle) then
	    error("no turtle")
	end_if
    end_if;
    [ Mode=List, extop(t,4) ]
end_proc:

# plot -- draw turtle path #
Turtle::plot:= proc(t) begin
    if testargs() then
	if not testtype(args(), Turtle) then
	    error("no turtle")
	end_if
    end_if;
    plot2d( Axes=None, Turtle::path(t) )
end_proc:

# end of file #
