#
| plotlib::xrotate       - Surface of revolution around the x-axis, i.e.
|                          rotation of curves around the x-axis
|
| args                   - <scene_options ,> object_1 <, object_2, ...>
|
|                        Hereby the <scene_options> describes the options
|                        which can be set in order to influence the whole
|                        graphics (like Scaling). These options are optio-
|                        nal. All options listed in the reference manual
|                        can be used here.
|
|                        object_i is used to specify the i-th object of
|                        the current graphics. This is to be given in form
|                        of a list:
|
|                        [[expr_x, expr_y], 
|                             x = [xmin, xmax], angle = [min_phi, max_phi], 
|                             options]
|
|                        expr_x  - describes the x-coordinates of the curve
|                        expr_y  - describes the y-coordinates of the curve
|                        x       - describes the independent variable of the
|                                  curve
|                        xmin    - minimum value for the range in which x
|                                  is evaluated
|                        pmax    - maximum value for the range in which x
|                                  is evaluated
|                        min_phi - minimum value for the rotation 
|                        max_phi - maximum value for the rotation
|                        options - used to influence the graphical represen-
|                                  tation of the object. All options listed
|                                  for plot3d() in the reference manual can
|                                  be used here.
#
plotlib::xrotate := proc()
    local i, j, list, s, fcos, fsin;
begin
    fcos := funcattr(cos, "float"):
    fsin := funcattr(sin, "float"):

    if args(0) = 0 then 
        plot(Dimension = 3)
    else 
        for i from 1 to args(0) do 
            list[i]:=args(i); 
            if 2 <= nops(op(list[i], 1)) then 
                list[i]:=subsop(list[i], [1] = 
                                (Mode = Surface,
                                [op(list[i],[1,1]),
                                 op(list[i],[1,2])*fcos(op(list[i], [3,1])),
                                 op(list[i],[1,2])*fsin(op(list[i], [3,1]))])):
            end_if; 
        end_for; 
        plot3d(list[j] $ j = 1..nops(list))
    end_if
end_proc:
