#
| plotlib::vector    - generates a graphical primitive called vector,
|                      i.e. a line with an arrow.
|
| args               - point1, point2, angle, length
|                      
|                      point1 and point2 are twodimensional points, which
|                      can be created by use of point().
|                      angle specifies the angle between the line and the
|                      arrow.
|                      length specifies the length of the arrow.
|
| plotlib::vector() returns a polygon consisting of three lines.
| Theses lines are connecting the points point1 with point2 and
| the endpoints of the arrow with the point point2.
#
plotlib::vector := proc(point1, point2, angle, length)
    local length_x, length_y, length_l, alpha, x, y, end1, end2,
          facos, fsin, fcos;
begin
    facos := funcattr(acos, "float"):
    fsin  := funcattr(sin, "float"):
    fcos  := funcattr(cos, "float"):

    #
    | Calculate the length of the line connecting point1 and point2.
    #
    length_x := op(point2, 1) - op(point1, 1):
    length_y := op(point2, 2) - op(point1, 2):
    length_l := sqrt(float(length_x^2 + length_y^2)):
    #
    | Calculate the angle between the line (point1, point2) and the
    | horicontal axes.
    #
    if length_l <> 0 then
        if length_y <> 0 then
            alpha := sign(length_y)*facos(length_x/length_l):
	else
	    alpha := facos(length_x/length_l):
	end_if:
    else
        alpha := 0:
    end_if:
    #
    | Calculate the endpoints of the arrow
    #
    x    := op(point2, 1) - length*length_l*fcos(alpha+angle):
    y    := op(point2, 2) - length*length_l*fsin(alpha+angle):
    end1 := point(x, y):
    x    := op(point2, 1) - length*length_l*fcos(alpha-angle):
    y    := op(point2, 2) - length*length_l*fsin(alpha-angle):
    end2 := point(x, y):
    #
    | Return the polygon
    #
    polygon(point1, point2, end1, point2, end2):
end_proc:
