#
| plotlib::fieldplot     - displays vectorfield in two variables
|
| args                   - <scene_options ,> object_1 <, object_2, ...>
|
|                        Hereby the <scene_options> describes the options
|                        which can be set in order to influence the whole
|                        graphics (like Scaling). These options are optio-
|                        nal. All options listed in the reference manual
|                        can be used here.
|
|                        object_i is used to specify the i-th object of
|                        the current graphics. This is to be given in form
|                        of a list:
|
|                        [expr_xy, x = [xmin, xmax], y = [ymin, ymax], 
|                             options]
|
|                        expr_xy - describes the field to be plotted
|                        x       - the first independent variable
|                        y       - the second independent variable
|                        xmin    - minimum value for the range in which x
|                                  is evaluated
|                        xmax    - maximum value for the range in which x
|                                  is evaluated
|                        ymin    - minimum value for the range in which 
|                                  y is evaluated
|                        ymax    - maximum value for the range in which 
|                                  y is evaluated
|                        options - used to influence the graphical represen-
|                                  tation of the object. All options listed
|                                  for plot3d() in the reference manual can
|                                  be used here.
#
plotlib::fieldplot := proc()
    local i, j, list, calc_pointlist;
begin

    calc_pointlist := proc(list)
    local    points, i, j, k, grad_x, grad_y,
             act_x, xmin, xmax, xgrid, delta_x,
             act_y, ymin, ymax, ygrid, delta_y,
    	     ratio, rat_x, rat_y;
    begin
        #
        | Check the arguments of list, left out
        #
        
        xmin    := float(op(list, [2,2,1])):
        xmax    := float(op(list, [2,2,2])):
        ymin    := float(op(list, [3,2,1])):
        ymax    := float(op(list, [3,2,2])):
        xgrid   := op(list, [4,2,1]):
        ygrid   := op(list, [4,2,2]):
        delta_x := (xmax - xmin)/(xgrid-1):
        delta_y := (ymax - ymin)/(ygrid-1):
        points  := []:
    
        for act_x from xmin to xmax step delta_x do
            for act_y from ymin to ymax step delta_y do
	        #
	        | Evaluate the expression expr_xy at the point
	        | (act_x, act_y).
	        #
                grad_x := float(subs(op(list, [1,1]), op(list, [2,1]) = act_x,
	                                              op(list, [3,1]) = act_y
		    			      )):
	        grad_y := float(subs(op(list, [1,2]), op(list, [2,1]) = act_x,
	                                              op(list, [3,1]) = act_y
		    			      )):
                ratio  := 1.0/(2.5*sqrt(grad_x^2+grad_y^2)):
                rat_x  := delta_x*ratio*grad_x:
                rat_y  := delta_y*ratio*grad_y:
                
                points := append(points, 
                                 plotlib::vector(point(act_x-rat_x,
	                                               act_y-rat_y),
				                 point(act_x+rat_x,
				                       act_y+rat_y),
  	                                         PI/6, 0.5)):
	    end_for:
        end_for:
        result := [Mode = List, points, (list[i] $ i = 5..nops(list))]:
        return(result);
    end_proc:


    loadlib("plotlib"):
    
    if args(0) = 0 then 
        plot(Dimension = 3)
    else 
        for i from 1 to args(0) do 
            list[i]:=args(i); 
            #
            | Check whether args(i) is an object or a scene-option.
            #
            if testtype(list[i], DOM_LIST) then 
	        list[i] := calc_pointlist(list[i]):
            end_if; 
        end_for; 
	plot2d(list[j] $ j = 1..nops(list))
    end_if
end_proc:



