# $Date: 1994/05/31 13:23:43 $  $Author: linus $  $Revision: 1.1 $ # 

#++
legendre(n, x) - generates the nth Legendre polynomial
++#

#--
computing Legendre polynomial H(n,x) by using the explicit formulae
L(0,x) = 1
L(n,x) = 1/(2^n * n!) * diff((x^2-1)^n, x$n), n > 0
--#
orthpoly::legendre := proc(n,x)
local T;
begin
	if args(0) <> 2 
		then
			error("wrong number of arguments!");
	end_if;

	if not (domtype(n) = DOM_INT)
		then 
			error("1st argument must be integer!");
	end_if;

	if n < 0 
		then
			error("1st argument must be positive!");
	end_if;

	if n = 0 
		then 
   			1;
		else
			if domtype(x) = DOM_IDENT
				then
					poly(1/(2^n * fact(n)) * diff((x^2 - 1) ^ n, x$n), [x], Expr);
				else
					poly(1/(2^n * fact(n)) * diff((T^2 - 1) ^ n, T$n), [T], Expr);
					evalp(%, T=x);
			end_if;
	end_if;
	%;
end_proc:
