# $Date: 1994/05/31 13:23:42 $  $Author: linus $  $Revision: 1.1 $ # 

#++
laguerre(n, a, x) - generates the nth Laguerre polynomial
++#

#--
Laguerre(n, a, x) - recurrence relation for Laguerre polynomials
--#

#--
computing Laguerre polynomial L(n, a, x) by using the recurrence relation
L(0,a,x) = 1
L(1,a,x) = -x + 1 + a
L(n,a,x) = (2*n+a-1-x)/n*L(n-1,a,x) - (n+a-1)/n*L(n-2,a,x)
--#
orthpoly::laguerre := proc(n,a,x)
local T;
begin
	if args(0) <> 3
		then 
			error("wrong number of arguments!");
	end_if;

	if not (domtype(n) = DOM_INT) 
		then 
			error("1st argument must be integer!");
	end_if;

	if n < 0 
		then
			error("1st argument must be positive!");
	end_if;

	if not (domtype(a) = DOM_INT) and not (domtype(a) = DOM_RAT)
                then 
                        error("2nd argument must be a rational number!");
        end_if;  

	if a <= -1 
		then
			error("1st argument must be greater than -1");
	end_if;

	if domtype(x) = DOM_IDENT
		then
			poly(orthpoly::Laguerre(n, a, x), [x], Expr);
		else
			poly(orthpoly::Laguerre(n, a, T), [T], Expr);
			evalp(%, T=x);
	end_if;
	%;
end_proc:

#--
the recursive part for the Laguerre polynomials.
the result is an expression, not a polynomial

orthpoly::Laguerre := proc(n, a, x)
local T;
option remember;
begin
	case n
		of 0 do
			T := 1;
			break;
		of 1 do 
			T := -x + 1 +a;
			break;
		otherwise
			T := (2*n+a-1-x)/n*orthpoly::Laguerre(n-1,a,x) - (n+a-1)/n*orthpoly::Laguerre(n-2,a,x)
	end_case;
	T;
end_proc:
--#

#--
iterative version for computing  the Laguerre polynomials.
the result is an expression, not a polynomial
--#
orthpoly::Laguerre := proc(n,a,x)
local T, i;
begin  
        case n   
           of 0 do
                T := 1;  
                break;
           of 1 do   
                T := -x + 1 +a;
                break;
           otherwise 
                1; -x + 1 +a;
                for i from 1 to n-1 do   
			expand((2*i+1+a-x)/(i+1)*eval(%1) - (i+a)/(i+1)*eval(%2));
                end_for; 
                T := %;
        end_case;
        T
end_proc:
