ode::vspace := proc(l,z)
local lambda,nb,yy,j,mu,a,b,y;
begin
   # compute the vector space y[1..n] of solutions of the homogeneous part #
   y:=[];
   while l<>[] do
      lambda:=l[1];
      if type(nb[lambda])<>DOM_INT then nb[lambda]:=0 end_if;
      yy:=exp(lambda*z)*z^nb[lambda];
      if has(lambda,I) or type(lambda)=DOM_COMPLEX then
         mu:=conjugate(lambda);
         if (j:=contains(l,mu))<>0 then
            if type(nb[mu])<>DOM_INT then nb[mu]:=0 end_if;
            if nb[lambda]=nb[mu] then
               # the vector space generated by exp((a+I*b)*z) and
                 exp((a-I*b)*z) is the same as that generated by
                 exp(a)*cos(b*z) and exp(a)*sin(b*z) #
               a:=Re(lambda); b:=Im(lambda);
               l[j]:=NIL;
               yy:=exp(a*z)*cos(b*z)*z^nb[mu],exp(a*z)*sin(b*z)*z^nb[mu];
               nb[mu]:=nb[mu]+1;
            end_if
         end_if;
      end_if;
      y:=append(y,yy);
      nb[lambda]:=nb[lambda]+1;
      l[1]:=NIL;
   end_while;
   y
end_proc:
