# ode::adjoint(l,x,f) solves the homogeneous linear equation 
  l[1]*u(x)+l[2]*diff(u(x),x)+...+l[n+1]*diff(u(x),x$n)+f = 0
  using the adjoint equation method (cf Zwillinger p. 149)

  Output: either a list of solutions for u(x) or FAIL.

  Example: ode::adjoint([8*x,2*x^2+4*x-3,x^2-x],x,-1);
           solves the equation 8*x*y+(2*x^2+4*x-3)*y'+(x^2-x)*y'' = 1
#

ode::adjoint := proc(l,x,inho)
local u,T,w,i,n,adj_eq,s,wstar,B,m,k;
begin
   userinfo(1,"trying the adjoint equation method");
   n:=nops(l)-1; # order of the equation #
   for i from 0 to n do T[i]:=(-1)^i*diff(l[i+1]*w(x),x$i) end_for;
   adj_eq := _plus(T[i] $ hold(i)=0..n);
   userinfo(2,"the ajoint equation is",collect(adj_eq,[diff(w(x),x$i)$hold(i)=0..n]));
   # the ajoint equation is linear, thus call ode::solve_linear #
   s:=ode::undet([coeff(adj_eq,[diff(w(x),x$i)],1) $ hold(i)=0..n],x);
   if s=FAIL then return(FAIL) end_if;
   wstar:=s[1]; # solution of adjoint equation #
   if type(wstar)="_mult" then wstar:=select(wstar,has,x) end_if;
   userinfo(2,"find a solution of the adjoint equation:",wstar);
   B:=ode::concomitant(u,w,x,l,n);
   B:=eval(subs(B,w(x)=wstar))+int(wstar*inho,x)+genident("C");
   solve(ode(B,u(x)))
end_proc:

ode::concomitant := proc(u,w,x,l,n)
begin
   if n=2 then u(x)*l[2]*w(x)+diff(u(x),x)*l[3]*w(x)-u(x)*diff(l[3]*w(x),x)
   else FAIL
   end_if
end_proc:
