# Friedrich Schwarz 11.3.1994 #

#--
numdivisors(a) - returns the number of the positive divisors of a
a - non-zero integer

[same function as numlib::tau]

numdivisors(a)
--#

numlib::numdivisors := proc(a)
  local i, w;
begin
   if testargs() then
     if args(0) <> 1 then
       error("expected one argument in function call")
     elif not testtype(a,NUMERIC) then
	     return(procname(args()))
	   elif domtype(a) <> DOM_INT then
	     error("argument must be an integer")
	   end_if
  end_if;
  if a = 0 then
    0
  else    
    w := ifactor(a);
    _mult(w[2*i+1] + 1 $ i = 1..(nops(w)-1)/2)
  end_if
end_proc:


