# Friedrich Schwarz 15.9.1994 #
  
#-----
mrootsPP(P,p,alpha) (to be used in mroots) :
input:
P     -- a univariate polynomial over the integers
p     -- a prime number
alpha -- a natural number
output:
the list of all integers z in {0,1,..,p^alpha -1}
such that P(z) = 0 (mod p^alpha)
-----#

numlib::mrootsPP := proc(P,p,alpha)
  local Q, a, i, T, q,  w, r, a_reg, a_sing, Q1, c, x, n, b_reg, b_sing;
begin
  Q := poly(P,IntMod(p));
  if iszero(Q) then
    a := [i $ hold(i) = 0..p-1]
  elif degree(Q) = 0 then
    a := []
  else 
    T := op(op(Q,2));     
	  q := gcd(Q,poly(T^p - T,IntMod(p)));     
         # q is the product of the different linear factors of Q #
    w := factor(q);
    r := (nops(w) -1)/2;
    a := [modp(-w[2*i](0),p) $ hold(i) = 1..r]
  end_if;
  if nops(a) = 0 or alpha = 1 then
    return(a)
  end_if;
  a_reg := [];
  a_sing := [];
  Q1 := D(Q);
  for x in a do
    c[x] := modp(Q1(x),p);
	  if c[x] <> 0 then
	    a_reg := append(a_reg,x)
	  else
	    a_sing := append(a_sing,x)
	  end_if
  end_for;
  n := nops(a_reg);
  if n > 0 then                                # lift the roots using hensel #
    b_reg := [numlib::regularHensel(P,a_reg[i],p,alpha,c[a_reg[i]]) 
	                                                   $ hold(i) = 1..n]
  else
    b_reg := []
  end_if;
  if nops(a_sing) > 0 then
    b_sing := numlib::singularHensel(P,a_sing,p,alpha)
  else
    b_sing := []
  end_if;
  _concat(b_reg,b_sing)
end_proc:
