# Friedrich Schwarz 15.9.1994 #       


#----- 
mroots(P,m) - calculates the roots of P modulo m
P - a univariate polynomial over the integers
m - a natural number

output : either the sorted list of all integers a in {0,1,..,m-1} such that
         P(a) = 0 (mod m) or FAIL

mroots   uses mrootsPP for prime power moduli
mrootsPP uses hensel for lifting roots
mroots   uses ifactor
mrootsPP uses gcd_mod and factor
-----#

numlib::mroots := proc(P,m)
  local makeLists, w, r, p, i, alpha, q, L, A, j;
  
begin
  if testargs() then
    if args(0) <> 2 then
      error("two arguments expected in function call")
	  elif not testtype(P,Type::PolyOf(DOM_INT,1)) then
	    error("1st argument must be a univariate polynomial over the integers")
	  elif not testtype(m,NUMERIC) then
	    return(procname(args()))
	  elif domtype(m) <> DOM_INT or m < 1 then
	    error("2nd argument must be a natural number")
	  end_if
  end_if;

  makeLists := proc()
    local X, i, j, k; 
  begin
    X := [[args(1)[i]] $ hold(i) = 1..nops(args(1))];
    for k from 2 to args(0) do
      X := [(append(X[j], args(k)[i]) $ hold(i) = 1..nops(args(k))) 
	                                              $ hold(j) = 1..nops(X)]
    end_for
  end_proc:

  if m = 1 then
    return([0])
  end_if;
  if degree(P) = 1 then
    return(numlib::lincongruence(lcoeff(P),-P(0),m))
  end_if;
  
  w := ifactor(m);
  r := nops(w) div 2;                     # number of primedivisors of m #
  p := [w[2*i] $ hold(i) = 1..r];                 # list of primedivisors of m #
  alpha := [w[2*i+1] $ hold(i) = 1..r];                    # list of exponents #
  q := [p[i]^alpha[i] $ hold(i) = 1..r]; 
  for i from 1 to r do
    L[i] := numlib::mrootsPP(P,p[i],alpha[i]); # mroots for prime power moduli #
    if nops(L[i]) = 0 then
      return(FAIL)
    end_if
  end_for;
  A := makeLists(L[i] $ hold(i) = 1..r);
  sort([numlib::ichrem(A[j],q) $ hold(j) = 1..nops(A)])
end_proc:
