# Friedrich Schwarz 11.3.1994 #

#--
legendre(a,p) - calculates the Legendre symbol (a | p)
a - integer
p - odd prime

legendre uses numlib::jacobi
--#

numlib::legendre := proc(a,p)
begin
  if testargs() then
    if args(0) <> 2 then
	    error("expected two arguments in function call")
    elif not testtype(a,NUMERIC) or not testtype(p,NUMERIC) then
	    return(procname(args()))
	  elif domtype(a) <> DOM_INT then
	    error("1st argument must be an integer")
	  elif domtype(p) <> DOM_INT or not isprime(p) or p = 2 then
	    error("2nd argument must be an odd prime")
	  end_if
  end_if;
	    
  numlib::jacobi(a,p)
end_proc:
