# Friedrich Schwarz 30.9.1994 #
  
#--
g_adic -- calculates g_adic representations
g_adic(a,g)
a - a nonnegative integer
g - an integer not in {-1,0,1}

output:
the list [c_0,c_1,c_2,..,c_r] such that
0 <= c_i < |g| for i = 0,1,2,..,r and
a = c_0 + c_1 g + c_2 g^2 + .. + c_r g^r;
g_adic(0,g) returns [0]
--#

numlib::g_adic := proc(a,g) 
  local b, k, c, i;

begin
  if testargs() then
    if args(0) <> 2 then
	    error("expected two arguments in function call")
    elif not testtype(a,NUMERIC) or not testtype(g,NUMERIC) then
	    return(procname(args()))
	  elif domtype(a) <> DOM_INT or a < 0 then
	    error("1st argument must be a nonnegative integer")
	  elif domtype(g) <> DOM_INT or abs(g) < 2 then
	    error("2nd argument must be an integer not in {-1,0,1}")
	  end_if
  end_if;
  if a = 0 then
    return([0])
  end_if;
  b := a;
  k := 0;
  while b <> 0 do
    c[k] := modp(b,g);
    b := (b - c[k]) div g;
    k := k + 1
  end_while;
  [c[i] $ hold(i) = 0..k-1]
end_proc:

