# Friedrich Schwarz 29.8.1994 #

#--
fromAscii(L) decodes a list of ASCII codes 
L - a list of ASCII-codes

non-printing characters are omitted 
(with exception of \t and \n) 
--#

numlib::fromAscii := proc(aList)
  local ascii2char, aTable, i; 
begin
  if testargs() then
    if args(0) <> 1 then
	  error("expected one argument in function call")
    elif domtype(aList) <> DOM_LIST then
	    error("argument must be a list of integers")
	elif nops(aList) > 0 then
      if not bool({op(map(aList,domtype))} = {DOM_INT}) then
	    error("argument must be a list of integers")
      end_if; 
      if min(op(aList)) < 0 or max(op(aList)) > 127 then
	    error("argument must be a list of ASCII-codes")
	  end_if
    end_if
  end_if; 
  ascii2char :=   ["",   "",   "",   "",   "",   "",   "",   "",
				   "", "\t", "\n",   "",   "",   "",   "",   "",
				   "",   "",   "",   "",   "",   "",   "",   "", 
				   "",   "",   "",   "",   "",   "",   "",   "", 
				   " ",  "!", "\"",  "#",  "$",  "%",  "&",  "'",
				   "(",  ")",  "*",  "+",  ",",  "-",  ".",  "/", 
				   "0",  "1",  "2",  "3",  "4",  "5",  "6",  "7", 
				   "8",  "9",  ":",  ";",  "<",  "=",  ">",  "?",
				   "@",  "A",  "B",  "C",  "D",  "E",  "F",  "G", 
				   "H",  "I",  "J",  "K",  "L",  "M",  "N",  "O", 
				   "P",  "Q",  "R",  "S",  "T",  "U",  "V",  "W", 
				   "X",  "Y",  "Z",  "[", "\\",  "]",  "^",  "_", 
				   "`",  "a",  "b",  "c",  "d",  "e",  "f",  "g", 
				   "h",  "i",  "j",  "k",  "l",  "m",  "n",  "o", 
				   "p",  "q",  "r",  "s",  "t",  "u",  "v",  "w", 
				   "x",  "y",  "z",  "{",  "|",  "}",  "~",  ""]:  
  aTable := table(i=ascii2char[aList[i]+1] $ hold(i)=1..nops(aList));
  tbl2text(aTable)
end_proc:

