#-
 ShortPathTo - shortest pathes to one single node
 ShortPathTo(G,v)
 ShortPathTo(G,v,w)
 ShortPathTo(G,v,<Path>, <Length>)
 ShortPathTo(G,v,w,<Path>, <Length>)
 Parameters:
   G - Network
   v,w - node of the network G
   Path, Length - keywords

 ShortPathTo(G,v) returns a table with the length of shortest pathes to 
 v to all other nodes in the network. ShortPathTo(G,v,w) gives the length 
 of a shortest path from w to v. Uses Network::rdijkstra (if there are 
 only non-negative edge weights) and Network::rbellman (if there are 
 negative edge weights).  If the optional argument Path is given, then 
 a table with shortest pathes are returned. If Length and Path are given, 
 then both the length of the shortest pathes and the pathes are returned.
-#
Network::ShortPathTo := proc(G,v)
local d,www,ww,V,Ew,Epr,a;
begin
   if testargs() then
      if args(0) < 2 or args(0) > 5 then
	     error("Wrong number of arguments!");
      end_if;
      Network::graph_check(G);
   end_if;

   T := Network::spath_arg_check(args());
   a := T[1];
   ww := T[2];
   www := T[3];

   V := Network::Vertex(G);
   Epr := Network::Epre(G);
   Ew := Network::EWeight(G);

   if min(op(Ew, [1..nops(Ew),2])) < 0 then
      d := Network::rbellman(V, Epr, Ew, v);
   else
      d := Network::rdijkstra(V, Epr, Ew, v);
   end_if;

   Network::spath_eval(V,d,a,ww,www,1);
end_proc:
