#- 
 MinCut - computes a minimal cut
 MinCut(G,q,s)
 Parameters:
   G - network
   q,s - vertices in G
 Computes a minimal cut seperating q and s in G.
 Uses Network::pp_fifo.
-#
Network::MinCut := proc(G,q,s)
local V, Ed, Ecap, Epo, Epr,flow,cutset,S,Q,i,j,e,vc;
begin
  if testargs() then
   	if args(0) <> 3 then
	   error("Wrong number of arguments!");
   	end_if;
	Network::graph_check(G);
	if not Network::IsVertex(G,q) and not Network::IsVertex(G,s) then
    	   error("Specified vertices are not contained in network!");
    	end_if;
  end_if;
  V := Network::Vertex(G);
  Ed := Network::Edge(G);
  Ecap := Network::ECapacity(G);
  Epo := Network::Epost(G);
  Epr := Network::Epre(G);

  flow := Network::pp_fifo(V, Ed, Ecap, Epo, Epr, q,s);
  vc := op(flow,1);
  flow := op(flow,2);
  #- 
   Compute a minimal cut [S,T] with q in S and s in T.
   S is the set of all nodes, for which there exists a path
   from q in the reduced network.
  -#
  S := {q}:
  Q := [q]:
  while Q <> [] do
     i := Q[1]:
     Q[1] := NIL;
     for j in Epo[i] do
        e := [i,j];
        if Ecap[e] - flow[e] > 0 then
           if contains(Q,j) = 0 then
              Q := append(Q,j);
              S := S union {j};
           end_if;
        end_if;
     end_for;
   end_while:
   cutset := [];
   for i in S do 
      for j in Epo[i] do
         if contains(S,j) then
	    next;
	 else
	    cutset := append(cutset,[i,j]);
	 end_if;
      end_for;
   end_for;
   vc, cutset;
end_proc:
