#-
 Algorithm for determining all pair shortest paths.
 Algorithm of Floyd, "Algorithm 97, Shortest Path",
 Comm. ACM, Vol. 5, 1962
 Running time O(|V|^3)
 Taken from: Ahuja, Magnanti, Orlin: Network Flows, Prentice-Hall, 1993
	     Section 5.6
-#
Network::floyd := proc(V, Edges, Ew)
local i,j,k,d,prec;
begin
   for i in V do 
      for j in V do 
	     if i=j then 
		    d[i,j] := 0;
	     elif contains(Edges, [i,j]) > 0 then
		    d[i,j] := Ew[[i,j]];
		    prec[i,j] := i;
	     else
		    d[i,j] := infinity;
		    prec[i,j] := 0;
	     end_if
      end_for;
   end_for;

   for k in V do	     
      for i in V do
         if d[i,k] + d[k,i] < 0 then 
            error("Network contains negative cycle!");
         end_if;
	     for j in V do
	        if d[i,j] > d[i,k] + d[k,j] then
		       d[i,j] := d[i,k] + d[k,j];
		       prec[i,j] := prec[k,j];
	        end_if;
	     end_for;
      end_for;
   end_for;
   d,prec
end_proc:
