#- 
 dijkstra - returns a shortest path from one single node
 Running time O(|V|^2).
 Works corretly for non-negative arc length only.
 Uses a subroutine 'choose' for choosing a node with minimum distance label.
-#
Network::dijkstra := proc(V, Epo, Ew, s)
local S, SC, C, d,e,i,j,prec,choose;
begin 

choose := proc(SC, d)
  local i,m,mi;
  begin
     mi := op(SC,1);
     m := d[mi];
     for i in SC do
	     if d[i] < m then
		   mi := i; 
		   m := d[i];
	     end_if;
     end_for;
     mi;
  end_proc:
  
   S := {}; SC := {op(V)};;
   C := (nops(V)+1) * max(op(Ew, [1..nops(Ew),2]));
   d := table((V[i] = C $ i=1..nops(V)));
   d[s] := 0;
   while nops(S) < nops(V) do 
      i := choose(SC, d);
      S := S union {i}; SC := SC minus {i};
      for j in Epo[i] do
         if d[j] > d[i] + Ew[[i,j]] then
	   d[j] := d[i] + Ew[[i,j]];
	   prec[j] := i;
         end_if;
      end_for;
   end_while;
   if C <> 0 then
      d := subs(d, C=infinity);
   end_if;
   [d,prec];
end_proc:


