#-
 Network::ConvertSSQ - converts a network to a single source, single sink network
 ConvertSSQ(N,q,s)
 Parameters:
   N - Network
   q - source (new node)
   s - sink (new node)
 Converts a network to a single source, single sink network.  The given nodes q and s 
 are inserted in the network. The are connected to the other nodes in the following way:
   [q,i] for every i with Network::VWeight[i] > 0
   [i,s] for every i with Network::VWeight[i] < 0
   ECapacity[[q,i]] := VWeight[i]   EWeight[[q,i]] := 0
   ECapacity[[i,s]] := VWeight[i]   EWeight[[i,s]] := 0
-#
Network::ConvertSSQ := proc(N,q,s)
local V,Vw,Ed,Ew,Ecap,f,v,Q,S,i,new_Edq,new_Eds;
begin
   if testargs() then
      Network::graph_check(N);
   end_if;

   V := Network::Vertex(N);

   if testargs() then
      if contains(V,q) <> 0 or contains(V,s) <> 0 then
	     error("Specified nodes are already nodes of the network!");
      end_if;
   end_if;

   Vw := Network::VWeight(N);
   f := fun(bool(Vw[args(1)] > 0));
   Q := select(V,f);
   f := fun(bool(Vw[args(1)] < 0));
   S := select(V,f);
   Ed := Network::Edge(N);
   new_Edq := [[q,Q[i]] $ i=1..nops(Q)];
   new_Eds := [[S[i],s] $ i=1..nops(S)];
   Ew := Network::EWeight(N);
   Ecap := Network::ECapacity(N);
   for i in Q do 
	Ew[[q,i]] := 0;
	Ecap[[q,i]] := Vw[i];
   end_for;
   for i in S do 
	Ew[[i,s]] := 0;
	Ecap[[i,s]] := -Vw[i];
   end_for;
   Vw[q] := infinity;
   Vw[s] := 0;
   Ed := Ed.new_Edq.new_Eds;
   V := V.[q,s];
   Network(V,Ed, hold(Vweight) = Vw, hold(Eweight) = Ew, hold(Capacity)=Ecap);
end_proc:



