#-
 AllShortPath - shortest pathes for every pair (i,j)
 AllShortPath(G,<Length>,<Path>)
 Parameter: 
   G - Network
 
 AllShortPath(G) gives a table with the length of a shortest path between 
 two nodes i and j for every i and j. If the keyword 'Path' is given, then a
 table is returned, which contains a shortest path for every pair (i,j). If
 there is no entry for a pair (i,j), then j cannot be reached from i in the
 network. If 'Length' and 'Path' are specified, then the distance table and the
 path table are returned.
 Uses Network::floyd.
-#
Network::AllShortPath := proc(G)
local a,d,dist,V,Ew,Edges,res,sp,path,u,v,w;
begin
   if testargs() then
      if args(0) < 1 or args(0) > 3 then
	     error("Wrong number of parameters!");
      end_if;
      Network::graph_check(G); 
   end_if;
   a := 0;
   for d from 2 to args(0) do
      case args(d) 
         of hold(Length) do
            a := a+1;
            break;
         of hold(Path) do 
            a := a + 10;
            break;
         otherwise
            error("Unknown argument!");
      end_case;
   end_for;
   V := Network::Vertex(G);
   Edges := Network::Edge(G);
   Ew := Network::EWeight(G);
   d := Network::floyd(V, Edges, Ew);
   dist := op(d,1);
   d := op(d,2);
   
  
   res := [];
   case a
      of 0 do 
         res := [dist];
         break;
      of 1 do 
         res := [dist];
         break
      of 11 do 
         res := [dist];
      of 10 do 
         sp := table();
         for v in V do 
            for i in V do  
               if (i = v) or dist[v,i] = infinity then
                   next;
               end_if;              
               path := [i];
               w := i;
               repeat 
	              u := d[(v,w)];
	              path := linsert(path,[u],1);
	              w := u;
               until (w = v) or (contains(sp,(v,w))) end_repeat;
               if contains(sp,(v,w)) then
	              path[1] := NIL;
	              sp[(v,i)] := sp[(v,w)].path;
               else
	              sp[(v,i)] := path;
               end_if;
            end_for;
         end_for;
         res := append(res,sp);
         break;
   end_case;
   op(res);
end_proc:

