#- 
 AddVertex - adds one or several vertices to a network
 AddVertex(G,x)
 AddVertex(G,x,Vweight=n)
 AddVertex(G,[x1,..,xn])
 AddVertex(G,[x1,..,xn], Vweight=[v1,..vn])
-#
Network::AddVertex := proc(G)
local V,i,a,b,c,Vw,lhs,rhs;
begin
   if testargs() then
      if args(0) < 2 or args(0) > 3 then
	     error("Wrong number of arguments!")
      end_if;
      Network::graph_check(G);
   end_if;
   
   case args(0) 
     of 2 do
	if testtype(args(2), DOM_LIST) then
	    V := Network::Vertex(G).args(2);
	    Vw := Network::VWeight(G);
	    for i in args(2) do
		Vw[i] := 0
      	    end_for;
	else
	   V := append(Network::Vertex(G),args(2));
	   Vw := Network::VWeight(G);
	   Vw[args(2)] := 0;
	end_if;
	break;
     of 3 do
	if not testtype(args(3), "_equal") then
	   error("Wrong vertex weights specification!");
	end_if;
	lhs := op(args(3),1); rhs := op(args(3),2);
	if lhs <> hold(Vweight) then
	   error("Vertex weight specification!")
	end_if;

	if testtype(args(2), DOM_LIST) then
	   #--
	   if not testtype(rhs, Type::ListOf(NUMERIC)) then
		error("Non numeric vertex weights!");
	   end_if;
	   --#
	   if nops(args(2)) <> nops(rhs) then
		error("Length of lists must be equal!");
	   end_if;
	   V := Network::Vertex(G).args(2);
	   Vw := Network::VWeight(G);
	   for i from 1 to nops(rhs) do
		Vw[args(2)[i]] := rhs[i];
	   end_for;
	else
	   #--
	   if not testtype(rhs, NUMERIC) then
		error("Non numeric vertex weight!");
	   end_if;
	   --#
	   V := append(Network::Vertex(G),args(2));
	   Vw := Network::VWeight(G);
	   Vw[args(2)] := rhs;
	end_if;
	break;
     otherwise
	error("Wrong number of arguments!")
     end_case;
     new(Network, V, Network::Edge(G), Vw, Network::ECapacity(G), 
	 Network::EWeight(G), Network::Epost(G), Network::Epre(G));
end_proc:
