#- 
 AddEdge - adds one or several edges to a network
 AddEdge(G, e)
 AddEdge(G, e, <Eweight=c>, <Capacity=t>)
 AddEdge(G, [e1,..,en])
 AddEdge(G, [e1,..,en], <Eweight=[c1,..,cn]>,<Capacity=[t1,..,tn]>)
-#
Network::AddEdge := proc(G)
local Ed,Ew,Ecap,Epr,Epo,i,a,b,c,e,f,lhs,rhs;
begin
   if testargs() then
      if args(0) < 2 or args(0) > 4 then
	     error("Wrong number of arguments!")
      end_if;
      Network::graph_check(G);
   end_if;
   Ed :=  Network::Edge(G);
   Ew := Network::EWeight(G);
   Ecap := Network::ECapacity(G);
   Epo := Network::Epost(G);
   Epr := Network::Epre(G);
   
   if testtype(args(2), Type::ListOf(DOM_LIST)) then
      a := [args()];
      f := fun(testtype(args(1), DOM_LIST));
      b := op(select(a, f));
      f := fun(testtype(args(1), "_equal"));
      c := select(a,f);
   
      #-
        check whether edges are specified correctly
      -#
       if testargs() then
   	      if not testtype(b, Type::ListOf(DOM_LIST)) then
   	         error("Wrong edge specification!")
   	      end_if;
   	      for e in b do
   	         if not testtype(e, Type::ListOf(Type::AnyType,2,2)) then
   		        error("Wrong edge specification!");
   	         end_if;
		  if not Network::IsVertex(G,e[1]) or not Network::IsVertex(G,e[2]) then
                     error("specified node is not part of the network!");
                  end_if;
                  if contains(Ed,e) <> 0 then
                    error("specified edge already contained in network!");
                  end_if;
   	      end_for;
       end_if;	
 
      Ed := Ed.b;
      for e in b do
          Epo[e[1]] := append(Epo[e[1]], e[2]);
          Epr[e[2]] := append(Epr[e[2]], e[1]);
	  Ew[e] := 1;
	  Ecap[e] := 1;
      end_for;

      for i in c do
         lhs := op(i,1); rhs := op(i,2);
         case lhs
            of hold(Eweight) do
		#--
   	        if not testtype(rhs, Type::ListOf(NUMERIC)) then
   		       error("Non numeric edge costs!");
   	        end_if;
		--#
   	        if nops(rhs) <> nops(b) then 
   		       error("Length of lists must be equal!");
   	        end_if;
   	        for i from 1 to nops(b) do
   		       Ew[b[i]] :=  rhs[i]
   	        end_for;
   	        break;
      	    of hold(Capacity) do
		#--
   	        if not testtype(rhs, Type::ListOf(NUMERIC)) then
   		       error("Non numeric edge capacities!");
   	        end_if;
		--#
   	        if nops(rhs) <> nops(b) then 
   		       error("Length of lists must be equal!");
   	        end_if;
   	        for i from 1 to nops(b) do
   		       Ecap[b[i]] :=  rhs[i]
   	        end_for;
   	        break;
   	    otherwise
   	        error("Unknown type!");
   	 end_case;
       end_for;


   else #- one single edge is changed -#
	a := [args()];
        f := fun(testtype(args(1), DOM_LIST));
        b := op(select(a, f));
        f := fun(testtype(args(1), "_equal"));
        c := select(a,f);
   
        #-
        check whether edge is specified correctly
        -#
        if testargs() then
   	       if not testtype(b, Type::ListOf(Type::AnyType,2,2)) then
   	          error("Wrong edge specification!")
   	       end_if;
	       if not Network::IsVertex(G,b[1]) or not Network::IsVertex(G,b[2]) then
                  error("specified node is not part of the network!");
               end_if;
               if contains(Ed,b) <> 0 then
                  error("specified edge already contained in network!");
               end_if;
        end_if;	
        Ed := append(Ed,b);
	Ew[b] := 1;
        Ecap[b] := 1;
        Epo[b[1]] := append(Epo[b[1]], b[2]);
        Epr[b[2]] := append(Epr[b[2]], b[1]);
   	
   	for i in c do
   	      lhs := op(i,1); rhs := op(i,2);
   	      case lhs
      	   	 of hold(Eweight) do
			#--
   		        if not testtype(rhs, NUMERIC) then
   			       error("Non numeric edge cost!");
   		        end_if;
			--#
   		        Ew[b] :=  rhs;
   		        break;
      	   	 of hold(Capacity) do
			#--
   		        if not testtype(rhs, NUMERIC) then
   			       error("Non numeric edge capacitiy!");
   		        end_if;
			--#
   			Ecap[b] :=  rhs;
   		        break;
   	         otherwise
   		        error("Unknown type!");
   	       end_case;
	    end_for;
	 end_if;
     	
     new(Network, Network::Vertex(G), Ed, Network::VWeight(G), Ecap, Ew, Epo, Epr);
end_proc:
