
misc::tcov := proc()
    local fd, getline1, getline2, lpr, i, j, l, file,
          line, cnt, filename, lines, max_file, result, 
          fname, format, PRETTY_PRINT;
    option hold;
begin

    getline1 := proc()
        local a, b;
    begin
          if finput(fd, a, b) = null() then
             fclose(fd); error("Unexpected EOF")
          elif a = -1 then
             null()
          else
             a, b
          end_if
    end_proc:

    getline2 := proc()
        local a;
    begin
          if finput(fd, a) = null() then
             fclose(fd); null()
          else
             a
          end_if
    end_proc:

    # Erzeugt Zeichenkette der L"ange width.               #
    # Ist strlen(string) < width, so wird der rechte Teil  #
    # der Zeichenkette mit fill_pattern aufgef"ullt, falls #
    # falls right = TRUE, sonst der linke Teil.            #  
 
    format := proc(string, width, fill_pattern, right)
       local i;
    begin
       string := "".string;
       for i from 1 to width - strlen(string) do
           if right then
              string := string.fill_pattern
           else
              string := fill_pattern.string
           end_if
       end_for;
       string
    end_proc:
 
    lpr := proc(string)
      begin format(string, 6, " ", FALSE) end_proc:
 
    #------------------ Hauptprogramm -------------------#

    if args(0) = 0 then
       return();
    end_if;

    fname := "tcov".getpid().".dat";

    # Aufruf des internen generischen test coverage (gcov). #
    # Dieser schreibt die in der Datei TCOV.README          #
    # beschriebenen Daten in die Datei tcov.dat, die        #
    # nun im folgenden aufbereitet werden.                  #

    result := gcov(context(args()), fname);

    if (fd := fopen(fname)) = FAIL then 
       error("could not open file ".fname) 
    end_if;

    # Der wesentliche Algorithmus, der das Datenfile  # 
    # ausliest und aufbereitet.                       #

    # Datenfile einlesen #

    while domtype((l := getline1())) <> DOM_NULL do
	   file := l[1] ; line := l[2] ;
       if domtype(lines[file]) <> DOM_LIST then
          lines[file] := []
       end_if;
       if contains(lines[file], line) > 0 then
          cnt[file][line] := cnt[file][line] + 1
       else
          cnt[file][line] := 1;
          lines[file] := append(lines[file], line)
       end_if
    end_while;

    max_file := -1;
    while domtype((l := getline2())) <> DOM_NULL do
       max_file := max_file +1;
       filename[max_file] := l;
    end_while;

    # Gelesende Daten aufbereiten #

    PRETTY_PRINT := FALSE;
    for i from 1 to max_file do
        if domtype(lines[i]) = DOM_LIST then
           print(Unquoted, "File: ".filename[i]);
           for j in lines[i] do
               print(Unquoted, 
                  "      Line:".lpr(j).":".lpr(cnt[i][j])." time(s)")
           end_for
        end_if
    end_for;

    gcov(NIL,fname); # Unlink tcov file #

    print(Unquoted, "");
    result

end_proc:

#--

TCOV.README
-----------
Das Datenfile hat die Form:

<int>:<int>:
  ~     ~
  ~     ~
<int>:<int>:
-1:-1:
<str>
  ~
<str>

<int> ganze Zahl >= 0
<str> Zeichenkette in "" eingeschlossen.

Der erste Eintrag ist der Index des zugeh"origen Dateinamens, der
zweite Eintrag die Zeilennummer. Nach der Zeile -1:-1: folgen die
Dateinamen. 

Bsp.:

0:2:
1:4:
-1:-1:
"test1":
"test2":

Zeile 2 der Datei test1, die den Index 0 hat, und Zeile 4 der
Datei test2, die den Index 1 hat, wurden durchlaufen.

--#
