# $Date: 1995/06/20 13:00:20 $ $Author: kg $ $Revision: 1.9.2.1 $ #

# kg, 14/02/95 #

#++
misc::makelib -- make binary library

misc::makelib(path, fnam)
misc::makelib(path)
misc::makelib()

path - path name (string)
fnam - file name (string)

misc::makelib(p, f) creates the binary library file for file p.f.".mu" and
stores it in p."BIN/".f.".mb".

misc::makelib() creates all binary library files (.mb files). In each
subdirectory of the library there must be a file 'INDEX" containing the
subdirectories and files contained in that directory. INDEX must be a text
file where each line has one of the forms

d:<dirname>	-- directory
f:<filename>	-- .mu-file

Note that there must not be any white space. The name of a subdirectory must
not contain a seperator like /. The filename must not contain the extension
.mu. (This implies that only  files having the extension .mu may be read.)

The files given by the INDEX file are read and thereby a binary file is
created. There must be a subdirectory BIN where the binary files are
stored.

misc::makelib(p) creates the binary library files for the files given by the
INDEX file contained in the directory given by p.
++#

misc::makelib:= proc()
    local makeall, compile, PRETTY_PRINT, sep, 
          path, binf, txtf, pref;
begin
    if args(0) > 2 then error("wrong no of args") end_if;
    PRETTY_PRINT:= FALSE;

    # compile - compile text into binary file #
    compile:= proc(txtf, binf)
        local ex;
    begin
        print(Unquoted, "creating ".binf);
	unalias(); # delete all aliases #
        ex:= fopen(txtf);
        if ex=FAIL then 
           print(Unquoted,"Warning: file ".txtf." not found");
           return();
        end_if;
        txtf:=ex;
        ex:= fopen(binf, Write);
        if ex=FAIL then
           error("Cannot write in ".binf.". Please create BIN directory if missing")
        end_if;
        binf:=ex;
        while ((ex:= finput(txtf))) <> null() do
            # evaluate alias and unalias statements #
            if domtype(ex) = DOM_EXPR then
                if contains({hold(alias), hold(unalias)}, op(ex,0)) then
                    ex;
                    eval(%);
                    next
                end_if
            end_if;
            fprint(binf, ex)
        end_while;
        fclose(binf);
        fclose(txtf);
    end_proc;
    
    # makeall - reads index file INDEX from directory dir and either
      recurses through subdirectories or reads files, thereby creating
      binary files #
    makeall:= proc(path)
        local idx, l, binf, txtf;
    begin
    	if args(0) = 0 then
	    txtf:= pref.sep."INDEX";
    	else
	    txtf:= pref.pathname(args())."INDEX";
    	end_if;
    	idx:= fopen(txtf);
	if idx = FAIL then
	    error("could not open ".txtf)
	end_if;
    	while ((l:= ftextinput(idx))) <> null() do
    	    l:= text2list(l, [":"]);
    	    if nops(l) <> 3 then next end_if;
    	    if l[1] = "d" then
    	    	makeall(args(), l[3])
    	    elif l[1] = "f" then
    	        l:= l[3];
		if args(0) = 0 then
		    txtf:= pref.sep.l.".mu";
		else
		    txtf:= pref.pathname(args()).l.".mu";
		end_if;
    	        binf:= pref.pathname(args(), "BIN").l.".mb";
		compile(txtf, binf);
    	    end_if
    	end_while;
    	fclose(idx);
    end_proc;
    
    # create binary files #
    if args(0) = 0 then
        if sysname() = "MACOS" then sep:= ":" else sep:= "" end_if;
	for pref in LIB_PATH do
	    makeall();
	end_for;
    elif args(0) = 1 then
        pref:= args(1);
        if sysname() = "MACOS" then 
            sep:= ":";
            if substring(pref, strlen(pref)-1, 1) = ":" then
                pref:= substring(pref, 0, strlen(pref)-1)
            end_if
        else 
            sep:= "" 
        end_if;
        makeall();
    else
        case sysname()
        of "MACOS" do sep:= ":"; break;
        of "MSDOS" do sep:= "\\"; break;
        of "UNIX" do  sep:= "/";
        end_case;
        
        path:= args(1);
        txtf:= args(2);
	if substring(path, strlen(path)-1, 1) <> sep then
	    path:= path.sep
	end_if;
	binf:= path."BIN".sep.txtf.".mb";
	txtf:= path.txtf.".mu";
	compile(txtf, binf);
    end_if;
end_proc:

# end of file #
