
#++
misc::genassop -- generate associative operator from binary one

misc::genassop(treeop, oneargv, binval)

treeop  - operator to call for subexpressions if there are more than 2 args
oneargv - value to return for one argument
binval  - expression to compute result if there are 2 args

misc::genassop generates an associative operator. Let
f:= misc::genassop(g,o,b). If there are more than 2 args the expression
f(a1,...,an) is computed as g(g(a1...ah), g(a(h+1)...an)) where h = n div 2.
If there is only one argument the expression f(a1) returns o. If there are
exactly 2 args the expression f(a1,a2) is computed as b. b must be an
expression containing args(1) and args(2) which computes the value of
f(a1,a2) and is valid as part of a fun.

Note that the arguments of misc::genassop are not evaluated.

The main usage of misc::genassop is to generate n-ary operations
_plus and _mult from the binary case.
++#

misc::genassop:= proc()
    option hold;
begin
    eval(subs(hold(fun((
    	case args(0)
    	of 1 do oneargv; break;
    	of 2 do binargv; break;
    	otherwise
    	    treeop(treeop(args(i) $ hold(i)=1..(args(0) div 2)),
    	    	   treeop(args(i) $ hold(i)=((args(0) div 2)+1)..args(0)))
    	end_case
    ))), hold(treeop)=args(1), hold(oneargv)=args(2), hold(binargv)=args(3)))
end_proc:

# end of file #
