alias(verify2=misc::check_globals_aux):

misc::checkFunction:=proc(f)
begin
   misc::checkGlobals(f);
   misc::checkLocals(f);
end_proc:

misc::checkGlobals := proc(f) local pars,locals,body;
   begin
      if type(f)<>DOM_PROC then return(NIL) end_if;
      pars := op(f,1);
      locals := op(f,2);
      body := op(f,4);
      verify2(body,{pars,locals});
      f
   end_proc:

verify2 := proc(s,pars_and_locals) local i;
   begin
      if contains({"args",DOM_RAT,DOM_BOOL,DOM_INT,DOM_STRING,DOM_FLOAT,DOM_COMPLEX,"error"},type(s)) then NIL
      elif type(s)=DOM_IDENT then
	 if contains({"DIGITS","DOM_RAT","DOM_POLY","DOM_STRING","DOM_IDENT","DOM_EXPR","DOM_BOOL","DOM_INT","DOM_COMPLEX","DOM_PROC","DOM_FLOAT","DOM_SET"},expr2text(s)) then return(NIL) end_if;
	 if not contains(pars_and_locals,s) then
	    print(Unquoted,"Warning: global variable used",s);
	 end_if;
      elif type(s)=DOM_PROC then
	 verify2(op(s,4),pars_and_locals union {op(s,1),op(s,2)})
      elif s<>op(s) then # to avoid infinite recursion #
	 for i from 1 to nops(s) do
	    if op(s,i)<>NIL then
	       if nops([op(s,i)])=1 then verify2(op(s,i),pars_and_locals)
	       else verify2([op(s,i)],pars_and_locals)
	       end_if
	    end_if
	 end_for
      end_if
   end_proc:

# adapted from purge_locals in MuPAD german manual page 78 #
misc::checkLocals := proc(f)
local notused;
begin
   if type(f)=DOM_PROC then
      notused:=select({op(f,2)},fun(not has(op(f,4),args(1))));
      if notused<>{} and notused<>{NIL} then
	 print(Unquoted,"Warning: these local variables were not used:",op(notused))
      end_if;
   end_if
end_proc:
