# #
# $Date: 1995/06/16 13:40:02 $  $Author: frankp $   $Revision: 1.5.2.1 $ #
# #
# frankp, 1/11/94 #

#++
  vecpot.mu

        linalg::vectorPotential -- computes the vector potential of 
				   a vector function

        vectorPotential(x,m,[Test])

        x:    list of three expressions (the vector function)
        m:    list of three variables
	Test: (optional) ident

	This function determines whether the vector potential of vector 
	function 'x' exists or not. FALSE is returned if this does not exist.

	The vector potential of x exits iff the divergence of x is zero.

	If the vector potential of x exists and option 'Test' is given	
	then TRUE is returned.
	Otherwise the vector potential of 'x' is computed and returned
	as a list.
++#

linalg::vectorPotential := proc(x,m)
    name linalg::vectorPotential;
    local Z, t, F;
begin
    if testargs() then
        if args(0) <> 2 and args(0) <> 3 then
            error("wrong no of args")
        end_if;
	if domtype(x) <> DOM_LIST then
	    error("first argument must be a list")
	end_if;
	if not testtype( m,Type::ListOfIdents(3,3) )
	or nops(x) <> 3 then
            error("expecting lists of length three")
        end_if;
	if args(0) = 3 then
	    if args(3) <> hold(Test) then
		error("invalid third argument")
	    end_if
	end_if
    end_if;

    if not iszero( _plus( diff(x[i],m[i]) $ hold(i)=1..3 ) ) then
	return( FALSE )
    elif args(0) = 3 then 
	return( TRUE ) 
    end_if;

    t := [NIL,NIL,0];
    t[1] := int(subs(x[2],m[3]=Z),Z=0..m[3]) -
	    int(subs(x[3],[m[3]=0,m[2]=Z]),Z=0..m[2]);
    t[2] := -int(subs(x[1],m[3]=Z),Z=0..m[3]);
    t
end_proc:

# end of file #
