# #
# $Date: 1995/01/14 18:27:04 $  $Author: frankp $   $Revision: 1.5 $ #
# #
# frankp, 22/02/94 #

#++
  swaprow.mu

	linalg::swapRow(A,k,l)  --  swaps row k with row l of matrix A
++#

linalg::swapRow := proc(A,k,l)
    name linalg::swapRow;
    local r;
begin
    if testargs() then
	if args(0) <> 3 then error("wrong no of args") end_if;
	if A::hasProp( MatrixCat ) <> TRUE then 
	    error("expecting a matrix") 
	end_if;
	if not testtype( k,Type::PosInt ) 
	or not testtype( l,Type::PosInt ) 
	then
	    error("indices must be positive integers");
	end_if;
	r := op( A::dimen(A),1 );
	if k > r or l > r then
	    error("indices out of range")
	end_if
    end_if;

    A::swapRow(A,k,l)
end_proc:

# end of file #
