# #
# $Date: 1995/07/17 07:26:59 $  $Author: frankp $   $Revision: 1.13.2.1 $ #
# #
# frankp, 21/06/94 #

#++
  setcol.mu

	linalg::setCol(A,p,c)  --  sets column p of A to column c

	A: matrix
	c: expression
	p: positive integer
++#

linalg::setCol := proc(A,p,c)
    name linalg::setCol;
    local T,t;
begin
    if testargs() then
	if args(0) <> 3 then error("wrong no of args") end_if;
	if A::hasProp( MatrixCat ) <> TRUE then
	    error("expecting a matrix")
	end_if;
	if not testtype( p,Type::PosInt ) then
	    error("index must be a positive integer")
	end_if;
	if p > op( A::dimen(A),2 ) then
	    error("index out of range")
	end_if;
	if A::constructor = SquareMatrix then
	    T := Matrix(A::coeffRing)
	else
	    T := domtype(A)
	end_if;
	if T <> domtype(c) then
	    t := T::convert(c);
            if t <> FAIL then c := t
	    else
		c := c::convert_to( c,T );
		if c = FAIL then
		    error("3rd argument is not a valid column")
		end_if
	    end_if
	end_if;
	t := c::dimen(c);
	if op(t,2) <> 1 or op(t,1) > op(A::dimen(A),1) then
	    error("wrong size of column vector")
	end_if
    end_if;

    if A::constructor = SquareMatrix then
        T := Matrix(A::coeffRing)
    else
        T := domtype(A)
    end_if;
    if T <> domtype(c) then
	t := T::convert(c);
	if t <> FAIL then c := t else c := c::convert_to( c,T ) end_if
    end_if;
	
    A::setCol( A,p,c )
end_proc:

# end of file #
