# #
# $Date: 1995/02/07 14:48:37 $  $Author: frankp $   $Revision: 1.3 $ #
# #
# frankp, 2/03/94 #

#++
  row.mu

     linalg::row(A,i)           -- return row i of matrix A
     linalg::row(A,i..j)        -- return the list of rows i to j of matrix A
     linalg::row(A,[i1,i2,...]) -- return rows i1,i2, ... of A
++#

linalg::row := proc(A,l)
    name linalg::row;
    local k;
begin
    if testargs() then
	if args(0) <> 2 then error("wrong no of args") end_if;
	if A::hasProp( MatrixCat ) <> TRUE then
	    error ("expecting a matrix")
	end_if;
	k := op( A::dimen(A),1 );
	if testtype( l,Type::PosInt ) then
	    if l > k then error("index out of range") end_if;
	elif type(l) = "_range" then
	    if not testtype( op(l,1),Type::PosInt ) 
	    or not testtype( op(l,2),Type::PosInt )
	    then
		error("expecting range of positive integers")
	    end_if;
	    if op(l,1) > k or op(l,2) > k then
		error("range larger than upper matrix bound")
	    end_if
        elif testtype(l,Type::ListOf(Type::PosInt,1)) then
            if max(op(l)) > k then
                error("indices in list larger than upper matrix bound")
            end_if
	else 
	    error("invalid 2nd argument")
	end_if
    end_if;

    if domtype(l) = DOM_INT then return( A::row(A,l) ) end_if;
    if domtype(l) = DOM_LIST then
        return( [A::row(A,l[i]) $ hold(i)=1..nops(l)] )
    end_if;
    k := op(l,1);
    if k > op(l,2) then return( NIL ) end_if;
    if k = op(l,2) then return( A::row( A,k ) ) end_if;
    [ A::row( A,i ) $ hold(i)=k..op(l,2) ]
end_proc:

# end of file #
