# #
# $Date: 1995/05/31 20:22:44 $  $Author: frankp $   $Revision: 1.4 $ #
# #
# frankp, 19/11/94 #

#++
  ogsystab.mu

        linalg::ogCoordTab -- a table of orthogonally curvilinear coordinate 
			      system including scale factors

        ogCoordTab[System{,Scales}](u1,u2,u3,[c])

        System    : name of an orthogonally curvilinear coordinate system
	Scales	  : ident
	u1,u2,u3  : variables
	[c]	  : (optional) a constant

	The coordinate system specified by 'System' and the scale
	factors are described in respect to the variables u1,u2,u3.

	The following systems are predefined:
	(0 <= theta <= Pi, 0 <= phi <= 2*Pi, u,v real)

	- Cartesian:			x,y,z

	- Spherical:			x = r*sin(theta)*cos(phi),
					y = r*sin(theta)*sin(phi),
					z = r*cos(theta)

	- Cylindrical:			x = r*cos(phi)
					y = r*sin(phi)
					z = z

	- ParabolicCylindrical:		x = 1/2*(u^2+v^2)
					y = u*v
					z = z

	- Torus:			x = (c-R*cos(theta))*cos(phi)
					y = (c-R*cos(theta))*sin(phi)
					z = R*sin(theta), 0 <= R < c 

	- RotationParabolic:		x = u*v*cos(phi)
					y = u*v*sin(phi)
					z = 1/2*(u^2-v^2)

	- EllipticCylindrical:		x = c*cosh(u)*cos(v)
					y = c*sinh(u)*sin(v)
					z = z, c > 0 constant

	The vectors of the orthogonally curvilinear coordinate systems are 
	of type DOM_LIST and not elements of category 'MatrixCat'. 
	Therefore the vectors may explicitly converted into elements of 
	category 'MatrixCat'.

	The user is able to add new orthogonally curvilinear coordinate 
	systems (see help pages for 'table').

        The scale factors g_i are defined by g_i := |diff( T(u),u_i )|,
        where T describes the orthogonal transformation x=T(u) with x 
        the cartesian coordinates and u the orthogonally cuvilinear 
	coordinates.

	Examples:
	> linalg::ogCoordTab[Spherical](r,theta,Phi);
        [[sin(theta) cos(Phi), sin(theta) sin(Phi), cos(theta)], [cos(theta) cos(
        Phi), cos(theta) sin(Phi), - sin(theta)], [- sin(Phi), cos(Phi), 0]]
	
	> linalg::ogCoordTab[Cylindrical,Scales](r,theta,Phi);
        [1, r, 1]
++#

linalg::ogCoordTab := table(
    (hold(Cartesian))=fun([[1,0,0],[0,1,0],[0,0,1]]),
    (hold(Cartesian),Scales)=fun([1,1,1]),

    (hold(Spherical))=fun([[sin(args(2))*cos(args(3)),sin(args(2))*sin(args(3)),cos(args(2))],
		  	   [cos(args(2))*cos(args(3)),cos(args(2))*sin(args(3)),-sin(args(2))],
			   [-sin(args(3)),cos(args(3)),0]]),
    (hold(Spherical),Scales)=fun([1,args(1),args(1)*sin(args(2))]),

    (hold(Cylindrical))=fun([[cos(args(2)),sin(args(2)),0],
			     [-sin(args(2)),cos(args(2)),0],
			     [0,0,1]]),
    (hold(Cylindrical),Scales)=fun([1,args(1),1]),

    (hold(ParabolicCylindrical))=fun(
	[[args(1)/(args(1)^2+args(2)^2)^(1/2),
	  args(2)/(args(1)^2+args(2)^2)^(1/2),
	  0],
	 [-args(2)/(args(1)^2+args(2)^2)^(1/2),
	  args(1)/(args(1)^2+args(2)^2)^(1/2),
	  0],
	  [0,0,1]]
    ),
    (hold(ParabolicCylindrical),hold(Scales))=fun(
	[(args(1)^2+args(2)^2)^(1/2),(args(1)^2+args(2)^2)^(1/2),1]
    ),
	
    (hold(RotationParabolic))=fun(
	[[args(2)*cos(args(3))/(args(2)^2+args(1)^2)^(1/2),
 	  args(2)*sin(args(3))/(args(2)^2*args(1)^2)^(1/2),
	  args(1)/(args(2)^2+args(1)^2)^(1/2)],
	 [args(1)*cos(args(3))/(args(1)^2+args(2)^2)^(1/2),
	  args(1)*sin(args(3))/(args(1)^2+args(2)^2)^(1/2),
	  -args(2)/(args(1)^2+args(2)^2)^(1/2)],
	 [-args(1)*args(2)*sin(args(3))/(args(1)*args(2)),
	  args(1)*args(2)*cos(args(3))/(args(1)*args(2)),
	 0]]
    ),
    (hold(RotationParabolic),hold(Scales))=fun(
	[(args(2)^2+args(1)^2)^(1/2),(args(2)^2+args(1)^2)^(1/2),args(1)*args(2)]
    ),

    (hold(EllipticCylindrical))=fun(
	[[args(4)*sinh(args(1))*cos(args(2))/(args(4)*(cosh(args(1))^2-cos(args(2))^2)^(1/2)),
	  args(4)*cosh(args(1))*sin(args(2))/(args(4)*(cosh(args(1))^2-cos(args(2))^2)^(1/2)),
	  0],
	 [-args(4)*cosh(args(1))*sin(args(2))/(args(4)*(cosh(args(1))^2-cos(args(2))^2)^(1/2)),
	  args(4)*sinh(args(1))*cos(args(2))/(args(4)*(cosh(args(1))^2-cos(args(2))^2)^(1/2)),
	  0],
	 [0,0,1]]
    ),
    (hold(EllipticCylindrical),hold(Scales))=fun(
	[args(4)*(cosh(args(1))^2-cos(args(2))^2)^(1/2),
	 args(4)*(cosh(args(1))^2-cos(args(2))^2)^(1/2),
	 1]
    ),

    (hold(Torus))=fun(
	[[-cos(args(2))*cos(args(3))/(cos(args(2))^2*cos(args(3))^2+
              cos(args(2))^2*sin(args(3))^2+sin(args(2))^2)^(1/2),
          -cos(args(2))*sin(args(3))/(cos(args(2))^2*cos(args(3))^2
              +cos(args(2))^2*sin(args(3))^2+sin(args(2))^2)^(1/2),
          sin(args(2))/(cos(args(2))^2*cos(args(3))^2+
              cos(args(2))^2*sin(args(3))^2+sin(args(2))^2)^(1/2)],
         [args(1)*sin(args(2))*cos(args(3))/(args(1)^2*sin(args(2))^2*cos(args(3))^2
	      +args(1)^2*sin(args(2))^2*sin(args(3))^2+args(1)^2*cos(args(2))^2)^(1/2),
          args(1)*sin(args(2))*sin(args(3))/(args(1)^2*sin(args(2))^2*cos(args(3))^2
	      +args(1)^2*sin(args(2))^2*sin(args(3))^2+args(1)^2*cos(args(2))^2)^(1/2),
          args(1)*cos(args(2))/(args(1)^2*sin(args(2))^2*cos(args(3))^2+args(1)^2*
	      sin(args(2))^2*sin(args(3))^2+args(1)^2*cos(args(2))^2)^(1/2)],
	 [-(args(4)-args(1)*cos(args(2)))*sin(args(3))/(abs(sin(args(3))*args(4)-
	      sin(args(3))*args(1)*cos(args(2)))^2+abs(cos(args(3))*args(4)-
	      cos(args(3))*args(1)*cos(args(2)))^2)^(1/2),
	  (args(4)-args(1)*cos(args(2)))*cos(args(3))/(abs(sin(args(3))*args(4)-
	      sin(args(3))*args(1)*cos(args(2)))^2+abs(cos(args(3))*args(4)-
	      cos(args(3))*args(1)*cos(args(2)))^2)^(1/2)],
	  [0]]
    ),
    (hold(Torus),hold(Scales))=fun(
	[(cos(args(2))^2*cos(args(3))^2+cos(args(2))^2*sin(args(3))^2+sin(args(2))^2)^(1/2),
	 (args(1)^2*sin(args(2))^2*cos(args(3))^2+args(1)^2*sin(args(2))^2*sin(args(3))^2+
	     args(1)^2*cos(args(2))^2)^(1/2),
	 (abs(sin(args(3))*args(4)-sin(args(3))*args(1)*cos(args(2)))^2+
	     abs(cos(args(3))*args(4)-cos(args(3))*args(1)*cos(args(2)))^2)^(1/2)]
    )
):

# end of file #
