# #
# $Date: 1995/05/31 20:57:01 $  $Author: frankp $   $Revision: 1.15 $ #
# #
# frankp, 06/09/94 #

#++
    ogset.mu

    linalg::ogSystem  --  returns an orthogonal system of vectors

	ogSystem( S )

	S : list or set of vectors

	Computes an orthogonal system of linearly independent vectors 
	in S using the algorithm of Gram-Schmidt.

	Are the vectors linearly dependend then the computed
        system will be linearly dependend too.

	The vectors must be of same dimensions and defined over a field. 
++#

linalg::ogSystem := proc(S)
    name linalg::ogSystem;
    local i, j, R, t, OS, bi, bj, aj, v, scalarProduct;
begin
    if testargs() then
	if args(0) <> 1 then error("wrong no of args") end_if;
	t := Type::ListOf;
	case domtype(S)  
	of DOM_SET  do 
	    t := Type::SetOf
	of DOM_LIST do
	    if nops(S) = 0 then break end_if;
	    bi := op(S,1);
	    if not testtype( bi,linalg::VectorOf(Type::AnyType) ) then
		error("expecting list or set of vectors")
	    end_if;
	    R := bi::coeffRing;
	    if not R::hasProp( Field ) then
		error("expecting vectors over a field")
	    end_if;
	    v := max( op(bi::dimen(bi)) );
	    if not testtype( S,t(linalg::VectorOf(R,v)) ) then
		error("vectors are not compatible")
	    end_if;
	    break
	otherwise
	    error("expecting list or set of vectors")
	end_case
    end_if;

    if nops(S) = 0 then return( S ) end_if;

    v := op(S,1);
    R := v::coeffRing;
    scalarProduct := linalg::scalarProduct;

    OS := [v];
    for j from 2 to nops(S) do
        aj := op(S,j);
        bj := aj;
	for i from 1 to nops(OS) do
            bi := OS[i];
	    t := scalarProduct(bi,bi);
	    if R::iszero( t ) then next end_if;
            t := R::negate( R::divex(scalarProduct(bi,aj),t) );
	    if not R::iszero( t ) then
                bj := v::_plus( bj,v::_mult(bi,t) ) 
	    end_if
        end_for;
	if not v::iszero(bj) then OS := append( OS,bj ) end_if
    end_for;
    
    if domtype(S) = DOM_LIST then OS else {op(OS)} end_if
end_proc:

# end of file #
