# #
# $Date: 1995/06/16 13:40:01 $  $Author: frankp $   $Revision: 1.14.2.1 $ #
# #
# frankp, 20.09.1994 #

#++
  nulspace.mu

	linalg::nullSpace  --  computes the "null space" of matrix

	nullSpace(A)

	A: matrix

	linalg::nullSpace(A) computes a basis for the null space
	of matrix A. A must belong to the category Field.
++#

linalg::nullSpace := proc(A)
    name linalg::nullSpace;
    local R, r, c, d, i, j, swc, v, Rnegate, ns, n;
begin
    if testargs() then
	if args(0) <> 1 then
	    error("wrong no of args")
	end_if;
	if A::hasProp( MatrixCat ) <> TRUE then
	    error("expecting a matrix")
	end_if;
	if not (A::coeffRing)::hasProp( Field ) then
	    error("expecting a matrix over a field")
	end_if
    end_if;

    R := A::coeffRing;
    d := A::dimen(A);
    c := op(d,2);
    r := op(d,1);
    userinfo(1,"perform Gauss-Jordan");
    A := linalg::gaussJordan(A);

    swc := [];
    d := 1;
    ns := R::iszero;
    for i from 1 to c do
	if d > r then break end_if;
        v := A[d,i];
        if ns(v) then swc := swc.[i]
        else d := d + 1
        end_if
    end_for;
    swc := swc.[j $ j=i..c]; # case r < c #
    if nops(swc) = 0 then return( [] ) end_if;

    userinfo(1,"kernel vectors are in cols ",swc); 
    d := R::one;
    Rnegate := R::negate;
    ns := [];
    for i in swc do
	n := A::newThis(c,1);
	v := A::col(A,i);
        for j from 1 to min(r,i-1) do n[j] := Rnegate(v[j]) end_for;
        n[i] := d;
        ns := append(ns,n)
    end_for;
    ns
end_proc:

# end of file #
