# #
# $Date: 1995/06/20 12:44:13 $  $Author: frankp $   $Revision: 1.1.2.1 $ #
# #
# frankp, 31/10/94 #

#++
  isOrthog.mu

        linalg::isOrthogonal -- tests for orthogonal matrices

        isOrthogonal(A)

        A: square matrix

        This function tries to find out if A is orthogonal.
        TRUE is returned if A is orthogonal.

        Matrix A is orthogonal iff A^(-1) = transpose(A). This is equivalent 
        to the fact that the columns of A build an orthonormal system (in
        respect to the scalar product defined by linalg::scalarProduct).
        
	Note that one can only be sure that A is not an orthogonal matrix
	if the axiom 'canonicalRep' is stated for the coefficient domain 
	of A. In respect to axiom 'canonicalRep' is stated or not, FALSE
	and FAIL is returned, respectivly.

	The coefficient domain of A has to be an integral domain.
++#

linalg::isOrthogonal := proc(A)
    name linalg::isOrthogonal;
    local i, j, n, R, ci, scalarProduct, ret, col;
begin
    if testargs() then
	if args(0) <> 1 then
	    error("wrong no of args")
	end_if;
	if A::hasProp( MatrixCat ) <> TRUE then
	    error("expecting a matrix")
	end_if;
	if not (A::coeffRing)::hasProp( IntegralDomain ) then
	    error("expecting matrix over an integral domain")
	end_if	
    end_if;
   
    n := A::dimen(A);
    if op(n,1) <> op(n,2) then return( FALSE ) end_if;
    R := A::coeffRing;
    if R::hasProp( canonicalRep ) = FALSE then
	ret := FAIL else ret := FALSE
    end_if;


    scalarProduct := linalg::scalarProduct;
    n := op(n,1);
    col := A::col;

    for i from 1 to n do
	ci := col(A,i);
	if not R::equal( scalarProduct( ci,ci ),R::one ) then
	    return( ret )
	end_if;
	for j from i+1 to n do
	    if not R::iszero( scalarProduct(ci,col(A,j)) ) then
		return( ret )
	    end_if
	end_for
    end_for;

    TRUE
end_proc: 

# end of file #
