# #
# $Date: 1995/05/31 19:50:23 $  $Author: frankp $   $Revision: 1.4 $ #
# #
# frankp, 06/02/95 #

#++
  isherm.mu

        linalg::isHermitian -- test for Hermitian matrices

        isHermitian(A)

        A: square matrix

	This function returns TRUE if A is Hermitian and FALSE otherwise.
	A is a Hermitian matrix iff conjugate(transpose(A)) = A.

	When the coefficient domain of \Mpar{A} does not provide the 
	method \Mfunc{conjugate}, then \Mpar{A} will be tested to be 
	symmetric.
++#

linalg::isHermitian := fun(
    (if testargs() then
	if args(0) <> 1 then
	    error("wrong no of args")
	end_if;
	if (args(1))::hasProp( MatrixCat ) <> TRUE then
	    error("expecting a square matrix")
	end_if;
	(args(1))::dimen(args(1));
	if op(%,1) <> op(%,2) then
	    error("expecting a square matrix")
	end_if
    end_if;
   
    domattr((args(1))::coeffRing, "conjugate");
    if % = FAIL then
	(args(1))::equal( args(1),(args(1))::transpose(args(1)) )
    else
        (args(1))::equal( 
	    args(1), (args(1))::transpose( (args(1))::conjugate(args(1)) )
	)
    end_if)
):

# end of file #
