# #
# $Date: 1995/01/14 18:26:45 $  $Author: frankp $   $Revision: 1.4 $ #
# #
# frankp, 1/11/94 #

#++
  grad.mu

        linalg::grad -- computes the vector gradient of an expression

	grad(x,m,[ogSystem])

	x       : expression
	m       : list of variables
	ogSystem: (optional) name or list of the scale factors of an 
	          orthogonally curvilinear coordinate system

	This function computes the gradient of x in respect to m in form of 
	a list.
	If only two arguments are given then 'linalg::grad' operates on
	cartesian coordinate system. 
	Hence the result is the vector v of partial derivatives whose i-th 
	entry is defined by v[i]:=diff( x,m[i] ).

	Otherwise 'linalg::grad' operates on the orthogonally curvilinear
	coordinate system specified by a list of scale factors or by a name 
	which scale factors are defined in table 'linalg::ogCoordTab'.

	The scale factors g_i are defined by g_i := |diff( T(u),u_i )|,
	where T describes the orthogonal transformation x=T(u) with x 
	the cartesian coordinates and u the orthogonally curvilinear
	coordinates.
++#

linalg::grad := proc(V,var)
    name linalg::grad;
    local g; 
begin
    if testargs() then
	if args(0) <> 2 and args(0) <> 3 then
	    error("wrong no of args")
	end_if;
	if not testtype( var,Type::ListOfIdents(1) ) then
	    error("2nd argument must be a list of variables")
	end_if;
	if args(0) = 3 then
	    if nops(var) < 3 then
		error("2nd argument must be a list of at most 3 variables")
	    end_if;
	    if domtype(args(3)) <> DOM_LIST and 
	    type( linalg::ogCoordTab[args(3),hold(Scales)] ) = "_index"
	    then
		error("illegal or undefined coordinate system")
	    end_if
	end_if
    end_if;

    if args(0) = 3 then
	g := args(3);
	if domtype(g) <> DOM_LIST then
	    g := linalg::ogCoordTab[g,hold(Scales)](op(var))
	end_if;
	[1/g[1]*diff(V,var[1]),1/g[2]*diff(V,var[2]),1/g[3]*diff(V,var[3])]
    else
	[diff(V,var[i]) $ hold(i)=1..nops(var)]
    end_if
end_proc:

# end of file #
