# #
# $Date: 1995/02/09 12:28:41 $  $Author: frankp $   $Revision: 1.2 $ #
# #
# frankp, 06/02/95 #

#++
  extrmatr.mu

        linalg::extractMatrix -- extract a specified matrix from 
	                         from a given matrix

	extractMatrix(A, rows, cols)
        extractMatrix(v, rows)

        A          : matrix
	v          : vector
	rows, cols : lists or integer ranges of row/columns of A

	extractMatrix(A, rows, cols) returns the matrix of A selected
	by the row and col ranges, if rows and cols are integer ranges.
	Otherwise the matrix of A is selected whose (i,j)-th element
	is A(rows[i],cols[j]).

	extractMatrix(v,rows) does the same for a vector v.
++#

linalg::extractMatrix := proc(A,rows)
    name linalg::extractMatrix;
    local cols, d, i, j;
begin
    if testargs() then
	if args(0) < 2 or args(0) > 3 then
	    error("wrong no of args")
	end_if;
	if A::hasProp( MatrixCat ) <> TRUE then
	    error("expecting a matrix")
	end_if;
	d := A::dimen(A);
	if args(0) = 2 and op(d,1) <> 1 and op(d,2) <> 1 then
	    error("first argument must be a vector, or give a third argument")
	end_if;
	if type(rows) = "_range" then
	    if args(0) = 3 then
		i := op(d,1); j := op(d,2);
		cols := args(3);
	        if type(cols) <> "_range" then
		    error("third argument must be a range too")
	        end_if;
	        if not testtype(op(cols,1),Type::PosInt)
                   or not testtype(op(cols,2),Type::PosInt)
		then
		    error("third argument must be a range of positive integers")
		end_if;
	 	if op(cols,1) > op(cols,2) then
		    error("lower > upper bound in range")
		end_if;
	        if op(cols,1) > j or op(cols,2) > j
                then
                    error("third argument: ranges larger than upper matrix bound")
                end_if
	    else
		i := max(op(d))
	    end_if;
	    if not testtype(op(rows,1),Type::PosInt)
	       or not testtype(op(rows,2),Type::PosInt)
	    then
		error("2nd argument must be a range of positive integers")
	    end_if;
	    if op(rows,1) > op(rows,2) then
		error("lower > upper bound in range")
	    end_if;
	    if op(rows,1) > i or op(rows,2) > i then
		error("2nd argument: ranges larger than upper matrix bound")
	    end_if;
	    i := NIL: j := NIL
	else
	    if args(0) = 2 then cols := [] else cols := args(3) end_if;
	    if not testtype(rows,Type::ListOf(Type::PosInt,1)) or
	       not testtype(cols,Type::ListOf(Type::PosInt))
	    then
		error("expecting lists of positive integers")
	    end_if;
	    if max(op(rows)) > op(d,1) then
	        error("first argument: indices larger than upper matrix bound")
	    end_if;
	    if nops(cols) > 0 then
		if max(op(cols)) > op(d,2) then
                    error("2nd argument: indices larger than upper matrix bound")
		end_if
	    end_if
	end_if
    end_if;
   
    if args(0) = 2 then
	d := A::dimen(A);
	if domtype(rows) = DOM_LIST then
	    if op(d,1) = 1 then
		A::newThis( 1,nops(rows),[[A[rows[i]] $ i=1..nops(rows)]] )
	    else
		A::newThis( nops(rows),1,[A[rows[i]] $ i=1..nops(rows)] )
	    end_if
	else
            if op(d,1) = 1 then
                A::newThis( [[A[i] $ i=op(rows,1)..op(rows,2)]] )
            else
                A::newThis( [A[i] $ i=op(rows,1)..op(rows,2)] )
            end_if
	end_if
    else
	cols := args(3);
	if domtype(rows) = DOM_LIST then
	    A::newThis(nops(cols),nops(rows),
	        [[A[rows[i],cols[j]] $ j=1..nops(cols)] $ i=1..nops(rows)]
	    )
        else
	    A::newThis(
	        [[A[i,j] $ j=op(cols,1)..op(cols,2)] $ i=op(rows,1)..op(rows,2)]
	    )
	end_if
    end_if
end_proc: 

# end of file #
