# #
# $Date: 1995/07/12 15:05:56 $  $Author: frankp $   $Revision: 1.2.2.2 $ #
# #
# frankp, 14.06.1995 #

#++
  eigenvec.mu

	linalg::eigenVectors(A)  --  computes the eigenvectors of matrix A

	A: square matrix

	eigenVectors(A) computes the eigenvalues and
	eigenvectors of the matrix A.

	First all the eigenvalues of the matrix are computed using the 
	function linalg::eigenValues. 

	After this, for any eigenvalue u the matrix equation
	(I*u - A)*X = 0, where I denotes the identity matrix, is solved 
	using the Gauss-Jordan algorithm (linalg::gaussJordan).
	If A is not of category IntegralDomain, then an error message 
	will be given.

	The result is a list of sublists. Each sublist contains
	in that order an eigenvalue u, its algebraic multiplicity
	and a list of eigenvectors corresponding to u.

	When the sum of the algebraic multiplicities are not equal to
        the dimension of A then FAIL is returned.
++#

linalg::eigenVectors := proc(A)
    name linalg::eigenVectors;
    local n, s, i, j, k, r, ev, v, swc, d, R, Rnegate, B,
          de, Rmult, Riszero, t, isfield, vl, Rdivex, Rgcd;
begin
    if testargs() then
	if args(0) <> 1 then
	    error("wrong no of args")
	end_if;
	if A::hasProp( MatrixCat ) <> TRUE then
	    error("expecting a square matrix")
	end_if;
	if not (A::coeffRing)::hasProp( IntegralDomain ) then
	    error("expecting matrix over an integral domain")
	end_if;
	n := A::dimen(A);
	if op(n,1) <> op(n,2) then
	    error("expecting a square matrix")
	end_if
    end_if;

    userinfo(1,"compute the eigenvalues");
    n := op(A::dimen(A),1);
    s := linalg::eigenValues(A,hold(All));
    if _plus(op(s,[i,2]) $ i=1..nops(s)) <> n then
	return( FAIL )
    end_if;

    R := A::coeffRing;
    Rnegate := R::negate;
    Riszero := R::iszero;
    Rmult := R::_mult;
    Rdivex := R::divex;
    Rgcd := R::gcd;
    isfield := R::hasProp( Field );

    A := A::negate(A);
    ev := []; # list: EW e, alg. mult. of e, list of EV's to e #
    for k from 1 to nops(s) do
        B := A::_plus( A::newThis(n,n,op(s,[k,1]),Diagonal),A );
	userinfo(1,"perform Gauss-Jordan");
	userinfo(2,"  to matrix ",B);
	B := linalg::gaussJordan(B);

	userinfo(1,"get the kernel vectors");
	swc := []; de := [];
	t := R::one;
	d := 1;
        for i from 1 to n do
	    v := B[d,i];
            if Riszero(v) then swc := swc.[i]; de := de.[t]
	    else de := de.[v]; d := d + 1
	    end_if
        end_for;
	if nops(swc) = 0 then return( FAIL ) end_if;

	r := [];
	if isfield then
	    for i in swc do
		v := B::col(B,i);
		for j from 1 to i-1 do v[j] := Rnegate(v[j]) end_for;
		v[i] := t;
		r := r.[v]
	    end_for
	else
	    for i in swc do
	        v := B::col(B,i);
		if i = 1 then 
		    v[1] := de[1];
                    r := r.[v];
                    next
                end_if;
		vl := [Rnegate(v[1])];
	        t := de[1];
	        for j from 2 to i-1 do
		    d := v[j];
		    if not Riszero(d) then
			vl := vl.[Rmult(t,Rnegate(d))];
			t := Rmult(t,de[j])
		    else
			vl := vl.[d]
		    end_if
	        end_for;
	        vl := vl.[Rmult(t,de[i])];
		if Rgcd <> FAIL then
		    vl := map(vl,Rdivex,Rgcd(op(vl)))
		end_if;
		r := r.[v::newThis(n,1,vl)]
	   end_for
	end_if;
	ev := append(ev,[op(s,[k,1]),op(s,[k,2]),r])
    end_for;

    ev
end_proc:

# end of file #
