# #
# $Date: 1995/06/15 17:47:12 $  $Author: frankp $   $Revision: 1.7 $ #
# #
# frankp, 30/03/95 #

#++
  eigenval.mu

	linalg::eigenValues -- computes the eigenvalues of a matrix

	linalg::eigenValues(A [,All])
	
	A: square matrix
	 
	The call eigenValues(A) returns a list of the eigenvalues of A.
	If option All is given, then a list of sublists is returned,
	where each sublist contains an eigenvalue and its algebraic 
	multiplicity.

	If the coefficient ring of A is Float then a numerical
	solver will be used.
++#

linalg::eigenValues := proc(A)
    name linalg::eigenValues;
    local p, ____eigenValue_x, R, r, s, ev, i;
begin
    if testargs() then
        if args(0) < 1 or args(0) > 2 then
	    error("wrong no of args")
	end_if;
	if A::hasProp( MatrixCat ) <> TRUE then
	    error("expecting a matrix")
	end_if;
	if args(0) = 2 then
	    if args(2) <> hold(All) then
		error("expecting option 'All'")
	    end_if
	end_if
    end_if;

    R := A::coeffRing;
    if R::constructor = IntegerMod then
        if not R::hasProp( Field) then
            error("can't compute eigenvalues over ".expr2text(R)." yet")
        end_if
    elif R <> Integer and R <> Rational and R <> Float
    and R::constructor <> ExpressionField then
        error("can't compute eigenvalues over ".expr2text(R)." yet")
    end_if;

    p := linalg::charPolynomial( A,____eigenValue_x );
    if R = Float then
	r := map( float(hold(solve)(expr(p),____eigenValue_x)),R::convert )
    elif R::constructor = IntegerMod then
	r := map(select( solve(
	    poly(expr(p),[____eigenValue_x],IntMod(R::constructor_args[1]))
	,____eigenValue_x),testtype,R ),R::convert)
    else
        r := map(select( 
	    solve(expr(p),____eigenValue_x)
	,testtype,R ),R::convert)
    end_if;

    if args(0) = 2 then
	s := {op(r)};
	ev := [];
	for i from 1 to nops(s) do
	    ev := append( ev,[op(s,i),nops( select(r,R::equal,op(s,i)) )] )
	end_for;
	ev
    else
	r
    end_if
end_proc:

# end of file #
