# #
# $Date: 1995/02/07 12:37:11 $  $Author: frankp $   $Revision: 1.5 $ #
# #
# frankp, 31/10/94 #

#++
  diverge.mu

        linalg::divergence -- computes the divergence of a vector function
			      over fields

        divergence(x,m,[ogSystem])

        x       : list or vector of expressions (the vector function)
        m       : list or vector of variables (same length as x)
	ogSystem: (optional) name or list of the scale factors of an 
                  orthogonally curvilinear coordinate system

	This function computes the divergence of 'x'.
        If only two arguments are given 'linalg::divergence' operates on
        the cartesian coordinate system. Hence the result is the sum
	diff(x[i],m[i]) as i ranges over the length of 'x'.

        Otherwise 'linalg::divergence' operates on the orthogonally 
	curvilinear coordinate system specified by a list of scale 
	factors or by a name which scale factors are defined in table 
	'linalg::ogCoordTab'.

	'm' must be a list if 'x' is it, and a vector over a coefficient
	domain R if 'x' is a vector over R. In the last case the coefficient
	domain of 'x' has to provide a method "diff".
++#

linalg::divergence := proc(x,m)
    name linalg::divergence;
    local g, i, R, t, Rmult, Rinvert, Rnormal;
begin
    if testargs() then
	if args(0) <> 2 and args(0) <> 3 then
	    error("wrong no of args")
	end_if;
	if testtype( x,linalg::VectorOf(Type::AnyType) ) then
	    if not testtype( m,linalg::VectorOf(x::coeffRing,max(op(x::dimen(x)))) )
	    then
		error("expecting two vectors of same type and dimension")
	    end_if;
	    if not (x::coeffRing)::hasProp( Field ) then
		error("expecting vectors over a field")
	    end_if
	elif domtype(x) = DOM_LIST then
	    if not testtype( m,Type::ListOfIdents(nops(x) $ 2) ) then
		error("expecting lists of same length's")
	    end_if
	else
	    error("first argument must be a list or vector")
	end_if;
	if args(0) = 3 then
	    if domtype(m) = DOM_LIST then
		if nops(m) <> 3 then
		    error("expecting list of length 3")
	        end_if
	    elif max(op(m::dimen(m))) <> 3 then
		error("expecting vector of dimension 3")
	    end_if;
	    if domtype(args(3)) <> DOM_LIST and 
            type( linalg::ogCoordTab[args(3),hold(Scales)] ) = "_index"
            then
                error("illegal or undefined coordinate system")
            end_if
	end_if
    end_if;

    if args(0) = 2 then 
	if domtype(m) = DOM_LIST then
	    t := nops(m)
	else 
	    t := max(op(m::dimen(m))) 
	end_if;
	return( _plus( diff(x[i],m[i]) $ i=1..t ) )
    end_if;
    g := args(3);
    if domtype(g) <> DOM_LIST then
        g := linalg::ogCoordTab[g,hold(Scales)](m[i] $ i=1..3)
    end_if;
    if domtype(x) <> DOM_LIST then
	R := x::coeffRing;
	for i from 1 to 3 do
	    if not testtype(g[i],R) then
		error("unable to compute the divergence over ".expr2text(R))
	    end_if;
	    t := R::convert(g[i]);
	    if t <> FAIL then 
		g[i] := t 
	    else 
		g[i] := (g[i])::convert_to(g[i],R) 
	    end_if
	end_for;
	Rmult := R::_mult; 
	Rinvert := R::invert;
	Rnormal := id
    else
	Rmult := _mult;
	Rinvert := 1/id;
	Rnormal := normal
    end_if;
    Rnormal(Rmult( Rinvert(g[i]) $ hold(i)=1..3,
           _plus( diff(Rmult(g[2],g[3],x[1]),m[1]),
                  diff(Rmult(g[3],g[1],x[2]),m[2]),
                  diff(Rmult(g[1],g[2],x[3]),m[3]) )
    ))
end_proc:

# end of file #
