# #
# $Date: 1995/02/09 16:38:28 $  $Author: frankp $   $Revision: 1.17 $ #
# #
# frankp, 21/02/94 #

#++
  det.mu

	linalg::det -- computes the determinant of a matrix
		       over a commutative ring
++#

linalg::det := proc(A)
    name linalg::det;
    option remember;
    local Rmult, Rnegate, R, n;
begin
    if testargs() then
	if args(0) <> 1 then error("wrong no of args") end_if;
        if A::hasProp( MatrixCat ) <> TRUE then
	    error("expecting a matrix")
        end_if;
	if not (A::coeffRing)::hasProp( CommutativeRing ) then
	    error("expecting a matrix over a commutative ring")
	end_if;
	n := A::dimen(A);
	if op(n,1) <> op(n,2) then
	    error("expecting a square matrix")
	end_if
    end_if;

    n := op(A::dimen(A),1);
    if n < 4 then
	R := A::coeffRing;
	Rmult := R::_mult;
	Rnegate := R::negate
    end_if;
    case n
    of 1 do return( A[1,1] );
    of 2 do return( R::_plus( 
		    Rmult( A[1,1],A[2,2] ), 
 		    Rnegate( Rmult( A[1,2],A[2,1] ) )
                    )
            )
    of 3 do return( R::_plus( 
		    Rmult( A[1,1],A[2,2],A[3,3] ),
		    Rnegate( Rmult( A[1,1],A[2,3],A[3,2] ) ),
		    Rnegate( Rmult( A[2,1],A[1,2],A[3,3] ) ),
		    Rmult( A[2,1],A[1,3],A[3,2] ),
		    Rmult( A[3,1],A[1,2],A[2,3] ),
		    Rnegate( Rmult( A[3,1],A[1,3],A[2,2] ) )
                  )
             )
    otherwise if (A::coeffRing)::hasProp( IntegralDomain ) then
	          return( op(A::gaussElim(A),3) )
	      else
		  return( linalg::detOverCommutativeRing(A) )
	      end_if
    end_case
end_proc:

#--
        linalg::detOverCommutativeRing

        Computes the determinant of a square matrix over a 
	commutative ring using Laplace expansion formula.
--#

linalg::detOverCommutativeRing := fun(
    ((args(1))::coeffRing;
    case op( (args(1))::dimen(args(1)),1 )
    of 1 do args(1)[1,1]
    of 2 do (%)::_plus( 
                (%)::_mult( args(1)[1,1],args(1)[2,2] ), 
                (%)::negate( (%)::_mult( args(1)[1,2],args(1)[2,1] ) )
            );
	    break
    of 3 do (%)::_plus( 
                (%)::_mult( args(1)[1,1],args(1)[2,2],args(1)[3,3] ),
                (%)::negate( (%)::_mult( args(1)[1,1],args(1)[2,3],args(1)[3,2] ) ),
                (%)::negate( (%)::_mult( args(1)[2,1],args(1)[1,2],args(1)[3,3] ) ),
                (%)::_mult( args(1)[2,1],args(1)[1,3],args(1)[3,2] ),
                (%)::_mult( args(1)[3,1],args(1)[1,2],args(1)[2,3] ),
                (%)::negate( (%)::_mult( args(1)[3,1],args(1)[1,3],args(1)[2,2] ) )
            );
	    break
    otherwise (%)::_plus( (%)::_mult(
		(%)::_power((%)::negate((%)::one),i+1),args(1)[i,1], 
		linalg::detOverCommutativeRing( 
		    (args(1))::delRow((args(1))::delCol(args(1),1),i)
		) )
              $ hold(i)=1..op((args(1))::dimen(args(1)),1) )
    end_case)
):

# end of file #
