# #
# $Date: 1995/02/07 17:17:40 $  $Author: frankp $   $Revision: 1.5 $ #
# #
# frankp, 22/11/94 #

#++
  curl.mu

        linalg::curl -- computes the curl of a vector over fields

        curl(x,m,[ogSystem])

        x       : list or vector of expressions of length 3
        m       : list or vector of three variables
	ogSystem: (optional) name or list of the scale factors of an 
                  orthogonally curvilinear coordinate system

	This function computes the curl of 'x'.
        If only two arguments are given 'linalg::curl' operates on
        the cartesian coordinate system.

        Otherwise 'linalg::curl' operates on the orthogonally 
	curvilinear coordinate system specified by a list of scale 
	factors or by a name which scale factors are defined in table 
	'linalg::ogCoordTab'.

	'm' must be a list if 'x' is it, and a vector over a coefficient
	domain R if 'x' is a vector over R. In the last case the coefficient
	domain of 'x' has to provide a method "diff".
++#

linalg::curl := proc(x,m)
    name linalg::curl;
    local f, f1, f2, f3, g, i, R, rot;
begin
    if testargs() then
	if args(0) <> 2 and args(0) <> 3 then
	    error("wrong no of args")
	end_if;
	if testtype( x,linalg::VectorOf(Type::AnyType,3) ) then
	    if not testtype( m,linalg::VectorOf(x::coeffRing,3) )
	    then
		error("expecting two vectors of same type and dimension 3")
	    end_if;
	    if not (x::coeffRing)::hasProp( Field ) then
		error("expecting vectors over a field")
	    end_if
	elif domtype(x) = DOM_LIST then
	    if not testtype( m,Type::ListOfIdents(3,3) ) 
	    or nops(x) <> 3 then
		error("illegal arguments")
	    end_if
	else
	    error("first argument must be a list or vector of length 3")
	end_if;
	if args(0) = 3 then
	    if domtype(args(3)) <> DOM_LIST and 
            type( linalg::ogCoordTab[args(3),hold(Scales)] ) = "_index"
            then
                error("illegal or undefined coordinate system")
            end_if
	end_if
    end_if;

    if args(0) = 2 then 
	rot := [diff(x[3],m[2])-diff(x[2],m[3]),
		diff(x[1],m[3])-diff(x[3],m[1]),
		diff(x[2],m[1])-diff(x[1],m[2])];
	if domtype(x) = DOM_LIST then
	    return( rot )
	else
	    return( x::newThis(op(x::dimen(x)),rot) )
	end_if
    end_if;
    g := args(3);
    if domtype(g) <> DOM_LIST then
        g := linalg::ogCoordTab[g,hold(Scales)](m[i] $ i=1..3)
    end_if;
    if domtype(x) <> DOM_LIST then
	R := x::coeffRing;
	for i from 1 to 3 do
	    if not testtype(g[i],R) then
		error("unable to compute the curl over ".expr2text(R))
	    end_if;
	    f := R::convert(g[i]);
	    if f <> FAIL then 
		g[i] := f 
	    else 
		g[i] := (g[i])::convert_to(g[i],R) 
	    end_if
	end_for;

	f := map( [g[1],g[2],g[3]],R::invert );
	f1 := R::_mult(f[2],f[3]);
	f2 := R::_mult(f[1],f[3]);
	f3 := R::_mult(f[1],f[2]);
	x::newThis(op(x::dimen(x)),
	    [R::_mult( f1,R::_plus(diff(R::_mult(g[3],x[3]),m[2]),
                          R::negate(diff(R::_mult(g[2],x[2]),m[3])))
            ),
            R::_mult( f2,R::_plus(diff(R::_mult(g[1],x[1]),m[3]),
                          R::negate(diff(R::_mult(g[3],x[3]),m[1])))
            ),
            R::_mult( f3,R::_plus(diff(R::_mult(g[2],x[2]),m[1]),
                          R::negate(diff(R::_mult(g[1],x[1]),m[2])))
            )])
    else
	f := [ 1/g[1], 1/g[2], 1/g[3] ];
        f1 := f[2]*f[3]; f2 := f[1]*f[3]; f3 := f[1]*f[2];
	f := [f1*(diff(g[3]*x[3],m[2])-diff(g[2]*x[2],m[3])),
                f2*(diff(g[1]*x[1],m[3])-diff(g[3]*x[3],m[1])),
                f3*(diff(g[2]*x[2],m[1])-diff(g[1]*x[1],m[2]))
	       ];
	map(f,normal)
    end_if
end_proc:

# end of file #
